/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.core.model.xml.data.provider;

import com.savvytest.eclipse.core.model.xml.data.Array;
import com.savvytest.eclipse.core.model.xml.data.Data;
import com.savvytest.eclipse.core.model.xml.data.DataPackage;
import com.savvytest.eclipse.core.model.xml.data.provider.AddArrayCommand;
import com.savvytest.eclipse.core.model.xml.data.provider.ContainerDataItemProvider;
import com.savvytest.eclipse.core.model.xml.listructure.ArrayType;
import com.savvytest.eclipse.core.model.xml.listructure.BaseType;
import com.savvytest.eclipse.core.model.xml.listructure.ListructurePackage;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITableItemLabelProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

public class ArrayItemProvider
extends ContainerDataItemProvider
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource,
ITableItemLabelProvider {
    public ArrayItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
        }
        return this.itemPropertyDescriptors;
    }

    @Override
    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/Array"));
    }

    @Override
    public String getText(Object object) {
        return super.getText(object);
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        super.notifyChanged(notification);
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        int maxArraySize;
        Array array = (Array)object;
        ArrayType arrayType = (ArrayType)array.getBaseType();
        FeatureMap.Entry entry = (FeatureMap.Entry)arrayType.getElements().get(0);
        BaseType element = (BaseType)entry.getValue();
        int currentArraySize = array.getElements().size();
        if (currentArraySize < (maxArraySize = arrayType.getLength().intValue())) {
            Data data = element.convertToData();
            EReference feature = null;
            if (entry.getEStructuralFeature().equals(ListructurePackage.Literals.CONTAINER_TYPE__STRING)) {
                feature = DataPackage.Literals.CONTAINER_DATA__STRING;
            } else if (entry.getEStructuralFeature().equals(ListructurePackage.Literals.CONTAINER_TYPE__NUMBER)) {
                feature = DataPackage.Literals.CONTAINER_DATA__NUMBER;
            } else if (entry.getEStructuralFeature().equals(ListructurePackage.Literals.CONTAINER_TYPE__ARRAY)) {
                feature = DataPackage.Literals.CONTAINER_DATA__ARRAY;
            } else if (entry.getEStructuralFeature().equals(ListructurePackage.Literals.CONTAINER_TYPE__STRUCT)) {
                feature = DataPackage.Literals.CONTAINER_DATA__STRUCT;
            } else {
                return;
            }
            newChildDescriptors.add(this.createChildParameter(DataPackage.Literals.CONTAINER_DATA__ELEMENTS, FeatureMapUtil.createEntry(feature, data)));
        }
    }

    @Override
    public String getColumnText(Object object, int columnIndex) {
        Array array = (Array)object;
        switch (columnIndex) {
            case 0: {
                return this.getText(object);
            }
            case 1: {
                int currentSize = array.getElements().size();
                int maxValue = ((ArrayType)array.getBaseType()).getLength().intValue();
                return String.valueOf(Integer.toString(currentSize)) + '/' + Integer.toString(maxValue) + ' ' + this.getString("_UI_ContainerData_elements_feature");
            }
        }
        return this.getText(object);
    }

    @Override
    public Object getColumnImage(Object object, int columnIndex) {
        if (columnIndex == 0) {
            return this.getImage(object);
        }
        return null;
    }

    @Override
    protected Command createAddCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection<?> collection, int index) {
        return new AddArrayCommand(domain, owner, feature, collection, index);
    }
}

