/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.core.model.xml.data.util;

import com.savvytest.eclipse.core.model.xml.data.Array;
import com.savvytest.eclipse.core.model.xml.data.Atomic;
import com.savvytest.eclipse.core.model.xml.data.Boolean;
import com.savvytest.eclipse.core.model.xml.data.ContainerData;
import com.savvytest.eclipse.core.model.xml.data.Data;
import com.savvytest.eclipse.core.model.xml.data.DataPackage;
import com.savvytest.eclipse.core.model.xml.data.DataVisitor;
import com.savvytest.eclipse.core.model.xml.data.Number;
import com.savvytest.eclipse.core.model.xml.data.PersistentData;
import com.savvytest.eclipse.core.model.xml.data.String;
import com.savvytest.eclipse.core.model.xml.data.Struct;
import com.savvytest.eclipse.core.model.xml.data.util.PersistentDataMigrationInfo;
import com.savvytest.eclipse.core.model.xml.iface.Argument;
import com.savvytest.eclipse.core.model.xml.iface.BaseTypeExtension;
import com.savvytest.eclipse.core.model.xml.iface.util.InterfaceUtils;
import com.savvytest.eclipse.core.model.xml.listructure.ArrayType;
import com.savvytest.eclipse.core.model.xml.listructure.BaseType;
import com.savvytest.eclipse.core.model.xml.properties.util.PropertiesUtils;
import com.savvytest.eclipse.core.model.xml.testcase.util.TestcaseUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.util.FeatureMap;

public abstract class AbstractFillDataStructureVisitor
implements DataVisitor {
    private final Map<java.lang.String, BaseTypeExtension> baseTypeExtensionMap;
    private java.lang.String prefix = "";
    private HashMap<java.lang.String, PersistentData> persistentDataMap;
    private boolean addArrayElement;
    private int arrayIndex = -1;
    private boolean primaryArrayElement = true;
    private final PersistentDataMigrationInfo info;

    public AbstractFillDataStructureVisitor(Argument interfaceArgument, java.lang.String prefix, PersistentDataMigrationInfo info) {
        this.baseTypeExtensionMap = InterfaceUtils.createBaseTypeExtensionMap(interfaceArgument.getBaseTypeExtensions());
        this.info = info;
        if (prefix != null) {
            this.prefix = prefix;
        }
    }

    public AbstractFillDataStructureVisitor(Argument interfaceArgument) {
        this(interfaceArgument, null, null);
    }

    protected void init() {
        if (this.info != null) {
            this.info.unusedElements.addAll(this.getPersistentDatas());
        }
    }

    private java.lang.String makeId(BaseType baseType) {
        if (this.arrayIndex > -1) {
            return java.lang.String.valueOf(this.prefix) + "[" + this.arrayIndex + "]";
        }
        java.lang.String name = baseType.getName();
        if (this.prefix.isEmpty()) {
            return name;
        }
        return java.lang.String.valueOf(this.prefix) + "." + name;
    }

    @Override
    public Object visit(Struct struct) throws Exception {
        java.lang.String currentPrefix = this.prefix;
        int currentArrayIndex = this.arrayIndex;
        this.setBaseTypeExtension(struct);
        BaseType baseType = struct.getBaseType();
        java.lang.String id = this.makeId(baseType);
        PersistentData persistentData = this.findDataById(id);
        if (persistentData != null) {
            struct.setPersistentData(persistentData);
            persistentData.setVolatileData(struct);
            if (this.info != null) {
                this.info.unusedElements.remove(persistentData);
            }
        }
        this.arrayIndex = -1;
        this.prefix = id;
        for (FeatureMap.Entry entry : struct.getElements()) {
            Data data = (Data)entry.getValue();
            data.accept(this);
        }
        this.arrayIndex = currentArrayIndex;
        this.prefix = currentPrefix;
        return null;
    }

    @Override
    public Object visit(Array array) throws Exception {
        boolean currentPrimaryArrayElement = this.primaryArrayElement;
        boolean currentAddArrayElementFlag = this.addArrayElement;
        java.lang.String currentPrefix = this.prefix;
        int currentArrayIndex = this.arrayIndex;
        this.setBaseTypeExtension(array);
        ArrayType arrayType = (ArrayType)array.getBaseType();
        java.lang.String id = this.makeId(arrayType);
        PersistentData persistentData = this.findDataById(id);
        if (persistentData != null) {
            array.setPersistentData(persistentData);
            persistentData.setVolatileData(array);
            if (this.info != null) {
                this.info.unusedElements.remove(persistentData);
            }
        }
        this.prefix = id;
        int length = arrayType.getLength() == null ? 1 : arrayType.getLength().intValue();
        int index = 0;
        while (index < length) {
            FeatureMap.Entry entry;
            this.addArrayElement = false;
            this.arrayIndex = index;
            if (array.getElements().size() > index) {
                entry = (FeatureMap.Entry)array.getElements().get(index);
                Data data = (Data)entry.getValue();
                data.accept(this);
            } else {
                if (arrayType.getElements().isEmpty()) break;
                entry = (FeatureMap.Entry)arrayType.getElements().get(0);
                BaseType firstArrayTypeElement = (BaseType)entry.getValue();
                Data data = firstArrayTypeElement.convertToData();
                data.accept(this);
                if (!this.addArrayElement && !this.primaryArrayElement) break;
                if (data instanceof Struct) {
                    array.getElements().add(DataPackage.Literals.CONTAINER_DATA__STRUCT, data);
                } else if (data instanceof Array) {
                    array.getElements().add(DataPackage.Literals.CONTAINER_DATA__ARRAY, data);
                } else if (data instanceof Number) {
                    array.getElements().add(DataPackage.Literals.CONTAINER_DATA__NUMBER, data);
                } else if (data instanceof String) {
                    array.getElements().add(DataPackage.Literals.CONTAINER_DATA__STRING, data);
                } else {
                    throw new IllegalArgumentException("Unknown data type to check for: " + data == null ? null : data.getClass().getName());
                }
            }
            this.primaryArrayElement = false;
            ++index;
        }
        if (!this.addArrayElement) {
            this.addArrayElement = currentAddArrayElementFlag;
        }
        this.primaryArrayElement = currentPrimaryArrayElement;
        this.prefix = currentPrefix;
        this.arrayIndex = currentArrayIndex;
        return null;
    }

    @Override
    public Object visit(String string) throws Exception {
        PersistentData persistentData = this.visitAtomic(string);
        if (persistentData != null && PropertiesUtils.hasProperty(persistentData.getProperties(), PropertiesUtils.PropertyEnum.VALUE_STRING)) {
            string.setValue(PropertiesUtils.getStringProperty(persistentData.getProperties(), PropertiesUtils.PropertyEnum.VALUE_STRING));
        }
        return null;
    }

    @Override
    public Object visit(Number number) throws Exception {
        PersistentData persistentData = this.visitAtomic(number);
        if (persistentData != null && PropertiesUtils.hasProperty(persistentData.getProperties(), PropertiesUtils.PropertyEnum.VALUE_NUMBER)) {
            number.setValue(PropertiesUtils.getNumberProperty(persistentData.getProperties(), PropertiesUtils.PropertyEnum.VALUE_NUMBER));
        }
        return null;
    }

    @Override
    public Object visit(Boolean bool) throws Exception {
        PersistentData persistentData = this.visitAtomic(bool);
        if (persistentData != null && PropertiesUtils.hasProperty(persistentData.getProperties(), PropertiesUtils.PropertyEnum.VALUE_BOOLEAN)) {
            bool.setValue(PropertiesUtils.getBooleanProperty(persistentData.getProperties(), PropertiesUtils.PropertyEnum.VALUE_BOOLEAN));
        }
        return null;
    }

    private PersistentData visitAtomic(Atomic atomic) {
        this.setBaseTypeExtension(atomic);
        BaseType baseType = atomic.getBaseType();
        java.lang.String id = this.makeId(baseType);
        PersistentData persistentData = this.findDataById(id);
        if (persistentData != null) {
            atomic.setPersistentData(persistentData);
            persistentData.setVolatileData(atomic);
            if (this.info != null) {
                this.info.unusedElements.remove(persistentData);
            }
            this.addArrayElement = true;
        } else if (this.primaryArrayElement) {
            persistentData = this.createDataElement(id, atomic.getBaseType(), atomic);
            if (this.info != null) {
                this.info.addedElements.add(persistentData);
            }
        } else {
            List<PersistentData> result;
            ContainerData parent = (ContainerData)atomic.eContainer();
            if (parent != null && !(result = this.findDataByPrefix(this.prefix)).isEmpty()) {
                persistentData = this.createDataElement(id, atomic.getBaseType(), atomic);
            }
        }
        return persistentData;
    }

    private PersistentData createDataElement(java.lang.String id, BaseType baseType, Data data) {
        PersistentData persistentData = TestcaseUtil.createPersistentData(baseType, id, null, data);
        if (this.persistentDataMap == null) {
            this.fillPersistentDataMap();
        }
        this.persistentDataMap.put(id, persistentData);
        return persistentData;
    }

    private void setBaseTypeExtension(Data data) {
        if (data != null) {
            BaseType baseType = data.getBaseType();
            BaseTypeExtension baseTypeExtension = this.baseTypeExtensionMap.get(baseType.getId());
            data.setBaseTypeExtension(baseTypeExtension);
        }
    }

    private PersistentData findDataById(java.lang.String id) {
        if (this.persistentDataMap == null) {
            this.fillPersistentDataMap();
        }
        return this.persistentDataMap.get(id);
    }

    private List<PersistentData> findDataByPrefix(java.lang.String prefix) {
        if (this.persistentDataMap == null) {
            this.fillPersistentDataMap();
        }
        ArrayList<PersistentData> result = new ArrayList<PersistentData>();
        for (java.lang.String id : this.persistentDataMap.keySet()) {
            if (!id.startsWith(prefix)) continue;
            result.add(this.persistentDataMap.get(id));
        }
        return result;
    }

    private void fillPersistentDataMap() {
        EList<PersistentData> data = this.getPersistentDatas();
        this.persistentDataMap = new HashMap(data.size());
        for (PersistentData date : data) {
            this.persistentDataMap.put(date.getId(), date);
        }
    }

    protected abstract EList<PersistentData> getPersistentDatas();
}

