/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.core.model.xml.testcase;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum AssertEnum implements Enumerator
{
    NOASSERT(0, "noassert", "noassert"),
    EQ(1, "eq", "="),
    NE(2, "ne", "<>"),
    GT(3, "gt", ">"),
    GE(4, "ge", ">="),
    LT(5, "lt", "<"),
    LE(6, "le", "<="),
    SAME(7, "same", "same");

    public static final int NOASSERT_VALUE = 0;
    public static final int EQ_VALUE = 1;
    public static final int NE_VALUE = 2;
    public static final int GT_VALUE = 3;
    public static final int GE_VALUE = 4;
    public static final int LT_VALUE = 5;
    public static final int LE_VALUE = 6;
    public static final int SAME_VALUE = 7;
    private static final AssertEnum[] VALUES_ARRAY;
    public static final List<AssertEnum> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new AssertEnum[]{NOASSERT, EQ, NE, GT, GE, LT, LE, SAME};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static AssertEnum get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AssertEnum result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AssertEnum getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AssertEnum result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AssertEnum get(int value) {
        switch (value) {
            case 0: {
                return NOASSERT;
            }
            case 1: {
                return EQ;
            }
            case 2: {
                return NE;
            }
            case 3: {
                return GT;
            }
            case 4: {
                return GE;
            }
            case 5: {
                return LT;
            }
            case 6: {
                return LE;
            }
            case 7: {
                return SAME;
            }
        }
        return null;
    }

    private AssertEnum(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

