/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.remote.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.savvytest.eclipse.common.logging.LogLevel;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.common.util.editing.EditingUtility;
import com.savvytest.eclipse.core.model.xml.data.Argument;
import com.savvytest.eclipse.core.model.xml.data.Array;
import com.savvytest.eclipse.core.model.xml.data.Boolean;
import com.savvytest.eclipse.core.model.xml.data.Data;
import com.savvytest.eclipse.core.model.xml.data.Number;
import com.savvytest.eclipse.core.model.xml.data.Parameters;
import com.savvytest.eclipse.core.model.xml.data.String;
import com.savvytest.eclipse.core.model.xml.data.Struct;
import com.savvytest.eclipse.core.model.xml.data.impl.DataVisitorImpl;
import com.savvytest.eclipse.core.model.xml.data.provider.AbstractModifyPersistentDataCompoundCommand;
import com.savvytest.eclipse.core.model.xml.data.provider.AddArrayCommand;
import com.savvytest.eclipse.core.model.xml.data.provider.RemoveArrayCommand;
import com.savvytest.eclipse.core.model.xml.properties.Properties;
import com.savvytest.eclipse.core.model.xml.properties.util.PropertiesUtils;
import com.savvytest.eclipse.core.model.xml.testcase.Testcase;
import com.savvytest.eclipse.core.model.xml.testcase.util.BuildTestcaseDataVisitor;
import com.savvytest.eclipse.remote.rest.RestConnector;
import java.io.IOException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.edit.domain.EditingDomain;

public class RestParserVisitor
extends DataVisitorImpl {
    private final EditingDomain domain;
    private JsonNode currentNode;

    public RestParserVisitor(java.lang.String content) throws JsonProcessingException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        this.currentNode = mapper.readTree(content);
        this.domain = EditingUtility.createDefaultEditingDomain();
    }

    @Override
    public Object visitOutput(Testcase testcase) throws Exception {
        int i = 0;
        while (i < testcase.getOutputUi().size()) {
            Properties ifaceProperties = ((com.savvytest.eclipse.core.model.xml.iface.Argument)testcase.getInterface().getArguments().get(i)).getProperties();
            if (RestConnector.PropertyArgumentUsageTarget.OUTPUT.name().equals(PropertiesUtils.getStringProperty(ifaceProperties, PropertiesUtils.PropertyEnum.USAGE_TARGET))) {
                this.visit((Argument)testcase.getOutputUi().get(i));
                BuildTestcaseDataVisitor testDataVisitor = new BuildTestcaseDataVisitor((Argument)testcase.getOutputUi().get(i), "output.arg" + i, true);
                ((com.savvytest.eclipse.core.model.xml.testcase.Argument)testcase.getOutput().get(i)).getDatas().addAll(testDataVisitor.getTestcaseData());
            }
            ++i;
        }
        return null;
    }

    @Override
    public Object visit(Parameters parameters) throws Exception {
        if (parameters.getParameters().size() != 1) {
            SavvytestSettings.INSTANCE.getLogger().log("Parameters are only allowed to have one element.", LogLevel.ERROR, this);
            return null;
        }
        Data data = (Data)((FeatureMap.Entry)parameters.getParameters().get(0)).getValue();
        switch (PropertiesUtils.getUsage(data.getBaseTypeExtension().getProperties())) {
            case OUT: 
            case INOUT: {
                return super.visit(parameters);
            }
        }
        return null;
    }

    @Override
    public Object visit(Struct struct) throws Exception {
        JsonNode node = this.currentNode;
        if (!node.isObject()) {
            SavvytestSettings.INSTANCE.getLogger().log("Expected structure for " + struct.calculateId() + " but found: " + this.currentNode, LogLevel.WARNING, this);
            return null;
        }
        if (struct.getElements().size() < node.size()) {
            SavvytestSettings.INSTANCE.getLogger().log("Structure " + struct.getName() + " has fewer nodes then expected, so some values won't be parsed for node: " + node, LogLevel.WARNING, this);
        }
        for (FeatureMap.Entry entry : struct.getElements()) {
            Data data = (Data)entry.getValue();
            JsonNode child = node.get(data.getName());
            if (child == null) {
                SavvytestSettings.INSTANCE.getLogger().log("No corresponding element found for " + data.getName() + " in: " + node, LogLevel.WARNING, this);
                continue;
            }
            this.currentNode = child;
            this.visit(entry);
        }
        return null;
    }

    @Override
    public Object visit(Array array) throws Exception {
        AbstractModifyPersistentDataCompoundCommand command;
        JsonNode node = this.currentNode;
        int expectedSize = node.size();
        FeatureMap elements = array.getElements();
        while (expectedSize > elements.size()) {
            command = this.getTypeSafeCommand(AddArrayCommand.createAddArrayCommand(this.domain, array, elements.size()), AddArrayCommand.class);
            if (command == null) break;
            ((AddArrayCommand)command).setCreatePersistantData(false);
            command.setDirection(AbstractModifyPersistentDataCompoundCommand.Direction.OUTPUT);
            if (!((AddArrayCommand)command).canExecute()) continue;
            ((AddArrayCommand)command).execute();
        }
        while (expectedSize < elements.size()) {
            command = this.getTypeSafeCommand(RemoveArrayCommand.create(this.domain, array, expectedSize), RemoveArrayCommand.class);
            if (command == null) break;
            command.setDirection(AbstractModifyPersistentDataCompoundCommand.Direction.OUTPUT);
            if (!command.canExecute()) continue;
            command.execute();
        }
        int i = 0;
        while (i < elements.size()) {
            this.currentNode = node.get(i);
            this.visit((FeatureMap.Entry)elements.get(i));
            ++i;
        }
        return null;
    }

    @Override
    public Object visit(String string) throws Exception {
        JsonNode node = this.currentNode;
        if (!node.isValueNode()) {
            SavvytestSettings.INSTANCE.getLogger().log("Expected string for " + string.calculateId() + " but found: " + node, LogLevel.WARNING, this);
            return null;
        }
        string.setValue(node.asText());
        return null;
    }

    @Override
    public Object visit(Number number) throws Exception {
        JsonNode node = this.currentNode;
        if (!node.isNumber()) {
            SavvytestSettings.INSTANCE.getLogger().log("Expected number for " + number.calculateId() + " but found: " + node, LogLevel.WARNING, this);
            return null;
        }
        number.setValue(node.decimalValue());
        return null;
    }

    @Override
    public Object visit(Boolean bool) throws Exception {
        JsonNode node = this.currentNode;
        if (!node.isBoolean()) {
            SavvytestSettings.INSTANCE.getLogger().log("Expected boolean for " + bool.calculateId() + " but found: " + node, LogLevel.WARNING, this);
            return null;
        }
        bool.setValue(node.booleanValue());
        return null;
    }

    private <T extends Command> T getTypeSafeCommand(Command command, Class<T> clazz) {
        if (clazz.isAssignableFrom(command.getClass())) {
            return (T)command;
        }
        return null;
    }
}

