/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.remote.rest;

import com.savvytest.eclipse.common.savvytestnature.SavvytestTypeEnum;
import com.savvytest.eclipse.common.util.editing.EditingUtility;
import com.savvytest.eclipse.core.model.xml.listructure.Listructure;
import com.savvytest.eclipse.core.model.xml.listructure.ListructureFactory;
import com.savvytest.eclipse.core.model.xml.listructure.ListructurePackage;
import com.savvytest.eclipse.core.model.xml.listructure.NumberType;
import com.savvytest.eclipse.core.model.xml.listructure.StringType;
import com.savvytest.eclipse.core.model.xml.properties.PropertiesFactory;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;

public class SavvytestRestProjectNature
extends PlatformObject
implements IProjectNature {
    private IProject project;

    @Override
    public void configure() throws CoreException {
        IFile htmlResponseFile = this.project.getFolder(SavvytestTypeEnum.LISTRUCTURE.foldername).getFile("htmlResponse." + SavvytestTypeEnum.LISTRUCTURE.fileextension);
        try {
            this.createHtmlResponse(htmlResponseFile);
        }
        catch (IOException e) {
            throw new CoreException(new Status(4, "com.savvytest.eclipse.common", "Could not create HTML response listructure '" + htmlResponseFile.getName() + ". Error message: " + e.getMessage(), e));
        }
        ResourceAttributes attributes = new ResourceAttributes();
        attributes.setReadOnly(true);
        htmlResponseFile.setResourceAttributes(attributes);
    }

    private void createHtmlResponse(IFile file) throws IOException {
        Listructure listructure = ListructureFactory.eINSTANCE.createListructure();
        listructure.setId(URI.encodeOpaquePart(file.getProjectRelativePath().toString(), true));
        listructure.setProperties(PropertiesFactory.eINSTANCE.createProperties());
        NumberType responseCode = ListructureFactory.eINSTANCE.createNumberType();
        responseCode.setName("responseCode");
        responseCode.setProperties(PropertiesFactory.eINSTANCE.createProperties());
        listructure.getElements().add(ListructurePackage.eINSTANCE.getListructure_Number(), responseCode);
        StringType responseMessage = ListructureFactory.eINSTANCE.createStringType();
        responseMessage.setName("responseMessage");
        responseMessage.setProperties(PropertiesFactory.eINSTANCE.createProperties());
        listructure.getElements().add(ListructurePackage.eINSTANCE.getListructure_String(), responseMessage);
        listructure.updateIdsOfAllElements();
        AdapterFactoryEditingDomain domain = EditingUtility.createDefaultEditingDomain();
        EditingUtility.createListructure(file, listructure, domain);
    }

    @Override
    public void deconfigure() throws CoreException {
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public void setProject(IProject project) {
        this.project = project;
    }
}

