/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.runner.connector;

import com.savvytest.eclipse.common.logging.LogLevel;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.runner.connector.ConnectorExtensionPointInformation;
import com.savvytest.eclipse.runner.connector.IConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class ConnectionManager {
    private static final String CONNECTIONS_NODE = "connections";
    private static final String PARAMETERS_NODE = "parameters";
    private static final String CONNECTOR_ID_KEY = "connectorId";
    private static final String NAME_KEY = "name";
    private static final String DESCRIPTION_KEY = "description";
    private static final String DEFAULT_CONNECTION_KEY = "defaultConnection";
    private static final ConnectionManager INSTANCE = new ConnectionManager();

    public static final ConnectionManager getInstance() {
        return INSTANCE;
    }

    private ConnectionManager() {
    }

    private IEclipsePreferences getPreferences(IProject project) {
        return new ProjectScope(project).getNode("com.savvytest.eclipse.runner");
    }

    public List<IConnection> getConnections(IProject project) throws BackingStoreException {
        return new ArrayList<IConnection>(this.getConnectionsMap(project).values());
    }

    private Map<String, IConnection> getConnectionsMap(IProject project) throws BackingStoreException {
        LinkedHashMap<String, IConnection> connections = new LinkedHashMap<String, IConnection>();
        Preferences connectionsNode = this.getPreferences(project).node(CONNECTIONS_NODE);
        String[] stringArray = connectionsNode.childrenNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String childName = stringArray[n2];
            Preferences connectionNode = connectionsNode.node(childName);
            String id = connectionNode.get(CONNECTOR_ID_KEY, null);
            String name = connectionNode.get(NAME_KEY, null);
            String description = connectionNode.get(DESCRIPTION_KEY, null);
            Preferences parametersNode = connectionNode.node(PARAMETERS_NODE);
            HashMap<String, String> parameters = new HashMap<String, String>();
            String[] stringArray2 = parametersNode.keys();
            int n3 = stringArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                String parameterKey = stringArray2[n4];
                String parameter = parametersNode.get(parameterKey, null);
                parameters.put(parameterKey, parameter);
                ++n4;
            }
            IConnection connection = this.createConnection(project, id, name, description, parameters);
            if (connection != null) {
                connections.put(childName, connection);
            }
            ++n2;
        }
        return connections;
    }

    private IConnection createConnection(IProject project, String id, String name, String description, Map<String, String> parameters) {
        ConnectorExtensionPointInformation information = ConnectorExtensionPointInformation.getInformation(id);
        if (information == null) {
            SavvytestSettings.INSTANCE.getLogger().log("ID not matching any registered connectors: " + id, LogLevel.ERROR, this);
            return null;
        }
        IConnection connection = information.createConnection();
        connection.setConnectorId(id);
        connection.setName(name);
        connection.setDescription(description);
        connection.setProject(project);
        connection.getParameters().putAll(parameters);
        return connection;
    }

    public void setConnections(Collection<IConnection> connections, IProject project) throws BackingStoreException {
        Preferences connectionsNode = this.getPreferences(project).node(CONNECTIONS_NODE);
        String[] stringArray = connectionsNode.childrenNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String oldConnection = stringArray[n2];
            connectionsNode.node(oldConnection).removeNode();
            ++n2;
        }
        int i = 0;
        for (IConnection connection : connections) {
            Preferences connectionNode = connectionsNode.node(String.valueOf(i++));
            connectionNode.put(CONNECTOR_ID_KEY, connection.getConnectorId());
            connectionNode.put(NAME_KEY, connection.getName());
            if (connection.getDescription() != null) {
                connectionNode.put(DESCRIPTION_KEY, connection.getDescription());
            }
            Preferences parametersNode = connectionNode.node(PARAMETERS_NODE);
            for (Map.Entry<String, String> entry : connection.getParameters().entrySet()) {
                parametersNode.put(entry.getKey(), entry.getValue());
            }
        }
        connectionsNode.flush();
    }

    public IConnection getDefaultConnection(IProject project) throws BackingStoreException {
        String defaultConnection = this.getPreferences(project).node(CONNECTIONS_NODE).get(DEFAULT_CONNECTION_KEY, null);
        if (defaultConnection != null) {
            return this.getConnectionsMap(project).get(defaultConnection);
        }
        return null;
    }

    public void setDefaultConnection(IConnection connection, IProject project) throws BackingStoreException {
        Preferences connectionsNode = this.getPreferences(project).node(CONNECTIONS_NODE);
        if (connection == null) {
            connectionsNode.remove(DEFAULT_CONNECTION_KEY);
            connectionsNode.flush();
            return;
        }
        for (Map.Entry<String, IConnection> entry : this.getConnectionsMap(project).entrySet()) {
            if (!connection.equals(entry.getValue())) continue;
            connectionsNode.put(DEFAULT_CONNECTION_KEY, entry.getKey());
            connectionsNode.flush();
            return;
        }
        throw new IllegalArgumentException("Can't set the connection as default, as this connections isn't part of the connections within the project. Connection: " + connection + ". Project: " + project);
    }
}

