/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.hyperlink;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextPresentationListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.ITextViewerExtension4;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class DefaultHyperlinkPresenter
implements IHyperlinkPresenter,
ITextPresentationListener,
ITextInputListener,
IDocumentListener,
IPropertyChangeListener {
    public static final String HYPERLINK_COLOR = "hyperlinkColor";
    private ITextViewer fTextViewer;
    private Cursor fCursor;
    private Color fColor;
    private RGB fRGB;
    private boolean fDisposeColor;
    private IRegion fActiveRegion;
    private Position fRememberedPosition;
    private IPreferenceStore fPreferenceStore;

    public DefaultHyperlinkPresenter(IPreferenceStore store) {
        this.fPreferenceStore = store;
        this.fDisposeColor = true;
    }

    public DefaultHyperlinkPresenter(Color color) {
        this.fDisposeColor = false;
        this.fColor = color;
    }

    public DefaultHyperlinkPresenter(RGB color) {
        this.fRGB = color;
        this.fDisposeColor = true;
    }

    public boolean canShowMultipleHyperlinks() {
        return false;
    }

    public void showHyperlinks(IHyperlink[] hyperlinks) {
        Assert.isLegal(hyperlinks != null && hyperlinks.length == 1);
        this.highlightRegion(hyperlinks[0].getHyperlinkRegion());
        this.activateCursor();
    }

    public void hideHyperlinks() {
        this.repairRepresentation();
        this.fRememberedPosition = null;
    }

    public void install(ITextViewer textViewer) {
        StyledText text;
        Assert.isNotNull(textViewer);
        this.fTextViewer = textViewer;
        this.fTextViewer.addTextInputListener(this);
        if (this.fTextViewer instanceof ITextViewerExtension4) {
            ((ITextViewerExtension4)((Object)this.fTextViewer)).addTextPresentationListener(this);
        }
        if ((text = this.fTextViewer.getTextWidget()) != null && !text.isDisposed()) {
            if (this.fPreferenceStore != null) {
                this.fColor = this.createColor(this.fPreferenceStore, HYPERLINK_COLOR, text.getDisplay());
            } else if (this.fRGB != null) {
                this.fColor = new Color((Device)text.getDisplay(), this.fRGB);
            }
        }
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.addPropertyChangeListener(this);
        }
    }

    public void uninstall() {
        this.fTextViewer.removeTextInputListener(this);
        IDocument document = this.fTextViewer.getDocument();
        if (document != null) {
            document.removeDocumentListener(this);
        }
        if (this.fColor != null) {
            if (this.fDisposeColor) {
                this.fColor.dispose();
            }
            this.fColor = null;
        }
        if (this.fCursor != null) {
            this.fCursor.dispose();
            this.fCursor = null;
        }
        if (this.fTextViewer instanceof ITextViewerExtension4) {
            ((ITextViewerExtension4)((Object)this.fTextViewer)).removeTextPresentationListener(this);
        }
        this.fTextViewer = null;
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.removePropertyChangeListener(this);
        }
    }

    public void setColor(Color color) {
        Assert.isNotNull(this.fTextViewer);
        this.fColor = color;
    }

    public void applyTextPresentation(TextPresentation textPresentation) {
        if (this.fActiveRegion == null) {
            return;
        }
        IRegion region = textPresentation.getExtent();
        if (this.fActiveRegion.getOffset() + this.fActiveRegion.getLength() >= region.getOffset() && region.getOffset() + region.getLength() > this.fActiveRegion.getOffset()) {
            StyleRange styleRange = new StyleRange(this.fActiveRegion.getOffset(), this.fActiveRegion.getLength(), this.fColor, null);
            styleRange.underline = true;
            textPresentation.mergeStyleRange(styleRange);
        }
    }

    private void highlightRegion(IRegion region) {
        if (region.equals(this.fActiveRegion)) {
            return;
        }
        this.repairRepresentation();
        StyledText text = this.fTextViewer.getTextWidget();
        if (text == null || text.isDisposed()) {
            return;
        }
        this.fActiveRegion = region;
        if (this.fTextViewer instanceof ITextViewerExtension2) {
            ((ITextViewerExtension2)((Object)this.fTextViewer)).invalidateTextPresentation(region.getOffset(), region.getLength());
        } else {
            this.fTextViewer.invalidateTextPresentation();
        }
    }

    private void activateCursor() {
        StyledText text = this.fTextViewer.getTextWidget();
        if (text == null || text.isDisposed()) {
            return;
        }
        Display display = text.getDisplay();
        if (this.fCursor == null) {
            this.fCursor = new Cursor((Device)display, 21);
        }
        text.setCursor(this.fCursor);
    }

    private void resetCursor() {
        StyledText text = this.fTextViewer.getTextWidget();
        if (text != null && !text.isDisposed()) {
            text.setCursor(null);
        }
        if (this.fCursor != null) {
            this.fCursor.dispose();
            this.fCursor = null;
        }
    }

    private void repairRepresentation() {
        if (this.fActiveRegion == null) {
            return;
        }
        int offset = this.fActiveRegion.getOffset();
        int length = this.fActiveRegion.getLength();
        this.fActiveRegion = null;
        this.resetCursor();
        if (this.fTextViewer instanceof ITextViewerExtension2) {
            ((ITextViewerExtension2)((Object)this.fTextViewer)).invalidateTextPresentation(offset, length);
        } else {
            this.fTextViewer.invalidateTextPresentation();
        }
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
        if (this.fActiveRegion != null) {
            this.fRememberedPosition = new Position(this.fActiveRegion.getOffset(), this.fActiveRegion.getLength());
            try {
                event.getDocument().addPosition(this.fRememberedPosition);
            }
            catch (BadLocationException badLocationException) {
                this.fRememberedPosition = null;
            }
        }
    }

    public void documentChanged(DocumentEvent event) {
        if (this.fRememberedPosition != null) {
            if (!this.fRememberedPosition.isDeleted()) {
                event.getDocument().removePosition(this.fRememberedPosition);
                this.fActiveRegion = new Region(this.fRememberedPosition.getOffset(), this.fRememberedPosition.getLength());
            } else {
                this.fActiveRegion = new Region(event.getOffset(), event.getLength());
            }
            this.fRememberedPosition = null;
            StyledText widget = this.fTextViewer.getTextWidget();
            if (widget != null && !widget.isDisposed()) {
                widget.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        DefaultHyperlinkPresenter.this.hideHyperlinks();
                    }
                });
            }
        }
    }

    public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
        if (oldInput == null) {
            return;
        }
        this.hideHyperlinks();
        oldInput.removeDocumentListener(this);
    }

    public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
        if (newInput == null) {
            return;
        }
        newInput.addDocumentListener(this);
    }

    private Color createColor(IPreferenceStore store, String key, Display display) {
        RGB rgb = null;
        if (store.contains(key) && (rgb = store.isDefault(key) ? PreferenceConverter.getDefaultColor(store, key) : PreferenceConverter.getColor(store, key)) != null) {
            return new Color((Device)display, rgb);
        }
        return null;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (!HYPERLINK_COLOR.equals(event.getProperty())) {
            return;
        }
        if (this.fDisposeColor && this.fColor != null && !this.fColor.isDisposed()) {
            this.fColor.dispose();
        }
        this.fColor = null;
        StyledText textWidget = this.fTextViewer.getTextWidget();
        if (textWidget != null && !textWidget.isDisposed()) {
            this.fColor = this.createColor(this.fPreferenceStore, HYPERLINK_COLOR, textWidget.getDisplay());
        }
    }
}

