/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public abstract class SelectionListenerAction
extends BaseSelectionListenerAction {
    private static final List EMPTY_LIST = Arrays.asList(new Object[0]);
    private boolean selectionDirty = true;
    private List resources;
    private List nonResources;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected SelectionListenerAction(String text) {
        super(text);
    }

    protected void clearCache() {
        this.selectionDirty = true;
        this.resources = null;
        this.nonResources = null;
    }

    private final void computeResources() {
        this.resources = null;
        this.nonResources = null;
        Iterator e = this.getStructuredSelection().iterator();
        while (e.hasNext()) {
            Object next = e.next();
            if (next instanceof IResource) {
                if (this.resources == null) {
                    this.resources = new ArrayList(this.getStructuredSelection().size());
                }
                this.resources.add(next);
                continue;
            }
            if (next instanceof IAdaptable) {
                Object resource;
                IAdaptable iAdaptable = (IAdaptable)next;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((resource = iAdaptable.getAdapter(clazz)) != null) {
                    if (this.resources == null) {
                        this.resources = new ArrayList(this.getStructuredSelection().size());
                    }
                    this.resources.add(resource);
                    continue;
                }
            } else {
                ResourceMapping mapping;
                boolean resourcesFoundForThisSelection = false;
                IAdapterManager adapterManager = Platform.getAdapterManager();
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.mapping.ResourceMapping");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((mapping = (ResourceMapping)adapterManager.getAdapter(next, clazz)) != null) {
                    ResourceTraversal[] traversals = null;
                    try {
                        traversals = mapping.getTraversals(ResourceMappingContext.LOCAL_CONTEXT, new NullProgressMonitor());
                    }
                    catch (CoreException exception) {
                        IDEWorkbenchPlugin.log(exception.getLocalizedMessage(), exception.getStatus());
                    }
                    if (traversals != null) {
                        int i = 0;
                        while (i < traversals.length) {
                            IResource[] traversalResources = traversals[i].getResources();
                            if (traversalResources != null) {
                                resourcesFoundForThisSelection = true;
                                if (this.resources == null) {
                                    this.resources = new ArrayList(this.getStructuredSelection().size());
                                }
                                int j = 0;
                                while (j < traversalResources.length) {
                                    this.resources.add(traversalResources[j]);
                                    ++j;
                                }
                            }
                            ++i;
                        }
                    }
                }
                if (resourcesFoundForThisSelection) continue;
            }
            if (this.nonResources == null) {
                this.nonResources = new ArrayList(1);
            }
            this.nonResources.add(next);
        }
    }

    protected List getSelectedNonResources() {
        if (this.selectionDirty) {
            this.computeResources();
            this.selectionDirty = false;
        }
        if (this.nonResources == null) {
            return EMPTY_LIST;
        }
        return this.nonResources;
    }

    protected List getSelectedResources() {
        if (this.selectionDirty) {
            this.computeResources();
            this.selectionDirty = false;
        }
        if (this.resources == null) {
            return EMPTY_LIST;
        }
        return this.resources;
    }

    protected boolean resourceIsType(IResource resource, int resourceMask) {
        return (resource.getType() & resourceMask) != 0;
    }

    protected boolean selectionIsOfType(int resourceMask) {
        if (this.getSelectedNonResources().size() > 0) {
            return false;
        }
        Iterator e = this.getSelectedResources().iterator();
        while (e.hasNext()) {
            IResource next = (IResource)e.next();
            if (this.resourceIsType(next, resourceMask)) continue;
            return false;
        }
        return true;
    }
}

