/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.preferences;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferenceFilter;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.preferences.PreferenceTransferElement;
import org.eclipse.ui.internal.wizards.preferences.PreferencesMessages;
import org.eclipse.ui.internal.wizards.preferences.WizardPreferencesPage;

public class WizardPreferencesExportPage1
extends WizardPreferencesPage {
    private static final String PREFERENCESEXPORTPAGE1 = "preferencesExportPage1";

    protected WizardPreferencesExportPage1(String name) {
        super(name);
        this.setTitle(PreferencesMessages.WizardPreferencesExportPage1_exportTitle);
        this.setDescription(PreferencesMessages.WizardPreferencesExportPage1_exportDescription);
    }

    public WizardPreferencesExportPage1() {
        this(PREFERENCESEXPORTPAGE1);
    }

    protected String getOutputSuffix() {
        return ".epf";
    }

    protected String getDestinationValue() {
        String idealSuffix = this.getOutputSuffix();
        String destinationText = super.getDestinationValue();
        if (destinationText.length() != 0 && !destinationText.endsWith(File.separator)) {
            int dotIndex = destinationText.lastIndexOf(46);
            if (dotIndex != -1) {
                int pathSepIndex = destinationText.lastIndexOf(File.separator);
                if (pathSepIndex != -1 && dotIndex < pathSepIndex) {
                    destinationText = String.valueOf(destinationText) + idealSuffix;
                }
            } else {
                destinationText = String.valueOf(destinationText) + idealSuffix;
            }
        }
        return destinationText;
    }

    protected String getAllButtonText() {
        return PreferencesMessages.WizardPreferencesExportPage1_all;
    }

    protected String getChooseButtonText() {
        return PreferencesMessages.WizardPreferencesExportPage1_choose;
    }

    protected void createTransferArea(Composite composite) {
        this.createTransfersList(composite);
        this.createDestinationGroup(composite);
        this.createOptionsGroup(composite);
    }

    protected String getDestinationLabel() {
        return PreferencesMessages.WizardPreferencesExportPage1_file;
    }

    protected PreferenceTransferElement[] getTransfers() {
        PreferenceTransferElement[] elements = super.getTransfers();
        PreferenceTransferElement[] returnElements = new PreferenceTransferElement[elements.length];
        IPreferenceFilter[] filters = new IPreferenceFilter[1];
        IPreferencesService service = Platform.getPreferencesService();
        int count = 0;
        try {
            int i = 0;
            while (i < elements.length) {
                PreferenceTransferElement element = elements[i];
                filters[0] = element.getFilter();
                IPreferenceFilter[] matches = service.matches((IEclipsePreferences)service.getRootNode().node("instance"), filters);
                if (matches.length > 0) {
                    returnElements[count++] = element;
                }
                ++i;
            }
            elements = new PreferenceTransferElement[count];
            System.arraycopy(returnElements, 0, elements, 0, count);
        }
        catch (CoreException e) {
            WorkbenchPlugin.log(e.getMessage(), e);
            return new PreferenceTransferElement[0];
        }
        return elements;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean transfer(IPreferenceFilter[] transfers) {
        File exportFile = new File(this.getDestinationValue());
        if (!this.ensureTargetIsValid(exportFile)) {
            return false;
        }
        FileOutputStream fos = null;
        try {
            if (transfers.length <= 0) return true;
            try {
                fos = new FileOutputStream(exportFile);
            }
            catch (FileNotFoundException e) {
                WorkbenchPlugin.log(e.getMessage(), e);
                MessageDialog.openError(this.getControl().getShell(), new String(), e.getLocalizedMessage());
                return false;
            }
            IPreferencesService service = Platform.getPreferencesService();
            try {
                service.exportPreferences(service.getRootNode(), transfers, fos);
                return true;
            }
            catch (CoreException e) {
                WorkbenchPlugin.log(e.getMessage(), e);
                MessageDialog.openError(this.getControl().getShell(), new String(), e.getLocalizedMessage());
                return false;
            }
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    WorkbenchPlugin.log(e.getMessage(), e);
                    MessageDialog.openError(this.getControl().getShell(), new String(), e.getLocalizedMessage());
                    return false;
                }
            }
        }
    }

    protected String getFileDialogTitle() {
        return PreferencesMessages.WizardPreferencesExportPage1_title;
    }

    protected int getFileDialogStyle() {
        return 8192;
    }

    protected String getInvalidDestinationMessage() {
        return PreferencesMessages.WizardPreferencesExportPage1_noPrefFile;
    }
}

