/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.bookmarkexplorer;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.CreateMarkersOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.views.bookmarkexplorer.BookmarkMessages;
import org.eclipse.ui.part.MarkerTransfer;
import org.eclipse.ui.views.bookmarkexplorer.BookmarkAction;
import org.eclipse.ui.views.bookmarkexplorer.BookmarkNavigator;

class PasteBookmarkAction
extends BookmarkAction {
    private BookmarkNavigator view;

    public PasteBookmarkAction(BookmarkNavigator view) {
        super(view, BookmarkMessages.PasteBookmark_text);
        this.view = view;
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this, "org.eclipse.ui.paste_bookmark_action_context");
        this.setEnabled(false);
    }

    public void run() {
        MarkerTransfer transfer = MarkerTransfer.getInstance();
        final IMarker[] markerData = (IMarker[])this.view.getClipboard().getContents((Transfer)transfer);
        if (markerData == null) {
            return;
        }
        final ArrayList newMarkerAttributes = new ArrayList();
        final ArrayList newMarkerResources = new ArrayList();
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    int i = 0;
                    while (i < markerData.length) {
                        if (markerData[i].getType().equals("org.eclipse.core.resources.bookmark")) {
                            newMarkerResources.add(markerData[i].getResource());
                            newMarkerAttributes.add(markerData[i].getAttributes());
                        }
                        ++i;
                    }
                }
            }, null);
        }
        catch (CoreException e) {
            ErrorDialog.openError(this.view.getShell(), BookmarkMessages.PasteBookmark_errorTitle, null, e.getStatus());
            return;
        }
        Map[] attrs = newMarkerAttributes.toArray(new Map[newMarkerAttributes.size()]);
        IResource[] resources = newMarkerResources.toArray(new IResource[newMarkerResources.size()]);
        final CreateMarkersOperation op = new CreateMarkersOperation("org.eclipse.core.resources.bookmark", attrs, resources, BookmarkMessages.PasteBookmark_undoText);
        this.execute(op, BookmarkMessages.PasteBookmark_errorTitle, null, WorkspaceUndoUtil.getUIInfoAdapter(this.view.getShell()));
        if (op.getMarkers() != null) {
            this.view.getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    PasteBookmarkAction.this.view.getViewer().setSelection(new StructuredSelection(op.getMarkers()));
                    PasteBookmarkAction.this.view.updatePasteEnablement();
                }
            });
        }
    }
}

