/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.ide.undo.DeleteMarkersOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.views.markers.internal.ConcreteMarker;
import org.eclipse.ui.views.markers.internal.MarkerList;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerSelectionProviderAction;
import org.eclipse.ui.views.markers.internal.TaskMarker;
import org.eclipse.ui.views.markers.internal.TaskView;

public class ActionDeleteCompleted
extends MarkerSelectionProviderAction {
    private TaskView part;

    public ActionDeleteCompleted(TaskView part, ISelectionProvider provider) {
        super(provider, MarkerMessages.deleteCompletedAction_title);
        this.part = part;
        this.setEnabled(false);
    }

    public void run() {
        List completed = this.getCompletedTasks();
        if (completed.size() == 0) {
            MessageDialog.openInformation(this.part.getSite().getShell(), MarkerMessages.deleteCompletedTasks_dialogTitle, MarkerMessages.deleteCompletedTasks_noneCompleted);
            return;
        }
        String message = completed.size() == 1 ? MarkerMessages.deleteCompletedTasks_permanentSingular : NLS.bind(MarkerMessages.deleteCompletedTasks_permanentPlural, String.valueOf(completed.size()));
        if (!MessageDialog.openConfirm(this.part.getSite().getShell(), MarkerMessages.deleteCompletedTasks_dialogTitle, message)) {
            return;
        }
        IMarker[] markers = completed.toArray(new IMarker[completed.size()]);
        DeleteMarkersOperation op = new DeleteMarkersOperation(markers, this.getText());
        this.execute(op, MarkerMessages.deleteCompletedTasks_errorMessage, null, WorkspaceUndoUtil.getUIInfoAdapter(this.part.getSite().getShell()));
    }

    private List getCompletedTasks() {
        ArrayList<IMarker> completed = new ArrayList<IMarker>();
        MarkerList markerList = this.part.getVisibleMarkers();
        ConcreteMarker[] markers = markerList.toArray();
        int i = 0;
        while (i < markers.length) {
            TaskMarker taskMarker;
            ConcreteMarker marker = markers[i];
            if (marker instanceof TaskMarker && (taskMarker = (TaskMarker)marker).getDone() == 1) {
                completed.add(taskMarker.getMarker());
            }
            ++i;
        }
        return completed;
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(!selection.isEmpty());
    }
}

