/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.osgi.internal.provisional.verifier.CertificateVerifierFactory;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.configurator.ConfiguratorUtils;
import org.eclipse.update.configurator.IPlatformConfiguration;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IImport;
import org.eclipse.update.core.JarContentReference;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.internal.core.UpdateManagerLogWriter;
import org.eclipse.update.internal.core.UpdateSession;
import org.eclipse.update.internal.core.connection.ConnectionThreadManagerFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class UpdateCore
extends Plugin {
    public static boolean DEBUG;
    public static boolean DEBUG_SHOW_INSTALL;
    public static boolean DEBUG_SHOW_PARSING;
    public static boolean DEBUG_SHOW_WARNINGS;
    public static boolean DEBUG_SHOW_CONFIGURATION;
    public static boolean DEBUG_SHOW_TYPE;
    public static boolean DEBUG_SHOW_WEB;
    public static boolean DEBUG_SHOW_IHANDLER;
    public static boolean DEBUG_SHOW_RECONCILER;
    private static final String PREFIX = "org.eclipse.update.core";
    public static final String P_HISTORY_SIZE = "org.eclipse.update.core.historySize";
    public static final String P_CHECK_SIGNATURE = "org.eclipse.update.core.checkSignature";
    public static final String P_AUTOMATICALLY_CHOOSE_MIRROR = "org.eclipse.update.core.automaticallyChooseMirror";
    public static final String P_UPDATE_VERSIONS = "org.eclipse.update.core.updateVersions";
    public static final String EQUIVALENT_VALUE = "equivalent";
    public static final String COMPATIBLE_VALUE = "compatible";
    public static int DEFAULT_HISTORY;
    private static UpdateCore plugin;
    private static UpdateManagerLogWriter log;
    private static final String LOG_FILE = "install.log";
    private BundleContext context;
    private ServiceTracker pkgAdminTracker;
    private ServiceTracker verifierFactoryTracker;
    private ServiceTracker proxyTracker;
    private UpdateSession updateSession = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        DEFAULT_HISTORY = 100;
    }

    public UpdateCore() {
        plugin = this;
    }

    public static UpdateCore getPlugin() {
        return plugin;
    }

    private boolean getBooleanDebugOption(String flag, boolean dflt) {
        String result = Platform.getDebugOption(flag);
        if (result == null) {
            return dflt;
        }
        return result.trim().equalsIgnoreCase("true");
    }

    public static void debug(String s) {
        StringBuffer msg = new StringBuffer();
        msg.append(UpdateCore.getPlugin().toString());
        msg.append("^");
        msg.append(Integer.toHexString(Thread.currentThread().hashCode()));
        msg.append(" ");
        msg.append(s);
        System.out.println(msg.toString());
    }

    public static void warn(String s) {
        if (DEBUG && DEBUG_SHOW_WARNINGS) {
            if (s != null) {
                s = "WARNING: " + s;
            }
            UpdateCore.log(s, null);
        }
    }

    public static void warn(String s, Throwable e) {
        if (DEBUG && DEBUG_SHOW_WARNINGS) {
            if (s != null) {
                s = "UPDATE MANAGER INFO: " + s;
            }
            UpdateCore.log(s, e);
        }
    }

    public static void log(IStatus status) {
        UpdateCore.getPlugin().getLog().log(status);
    }

    public static void log(Throwable e) {
        UpdateCore.log("", e);
    }

    public static void log(String msg, Throwable e) {
        IStatus status = null;
        status = e instanceof CoreException ? ((CoreException)e).getStatus() : Utilities.newCoreException(msg, e).getStatus();
        if (status != null) {
            UpdateCore.log(status);
        }
    }

    public static void log(IInstallConfiguration newConfiguration) {
        if (log != null) {
            log.log(newConfiguration);
        }
    }

    private static File getInstallLogFile() throws IOException {
        IPlatformConfiguration config = ConfiguratorUtils.getCurrentPlatformConfiguration();
        URL configurationLocation = config.getConfigurationLocation();
        if (configurationLocation == null) {
            UpdateCore.warn("Unable to retrieve location for update manager log file");
            return null;
        }
        File updateStateLocation = null;
        if ("file".equalsIgnoreCase(configurationLocation.getProtocol())) {
            File path = new File(configurationLocation.getFile());
            updateStateLocation = new File(path.getParentFile(), LOG_FILE);
        }
        return updateStateLocation;
    }

    public static boolean isPatch(IFeature candidate) {
        IImport[] imports = candidate.getImports();
        int i = 0;
        while (i < imports.length) {
            IImport iimport = imports[i];
            if (iimport.isPatch()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.context = context;
        DEBUG = this.getBooleanDebugOption("org.eclipse.update.core/debug", false);
        if (DEBUG) {
            DEBUG_SHOW_WARNINGS = this.getBooleanDebugOption("org.eclipse.update.core/debug/warning", false);
            DEBUG_SHOW_PARSING = this.getBooleanDebugOption("org.eclipse.update.core/debug/parsing", false);
            DEBUG_SHOW_INSTALL = this.getBooleanDebugOption("org.eclipse.update.core/debug/install", false);
            DEBUG_SHOW_CONFIGURATION = this.getBooleanDebugOption("org.eclipse.update.core/debug/configuration", false);
            DEBUG_SHOW_TYPE = this.getBooleanDebugOption("org.eclipse.update.core/debug/type", false);
            DEBUG_SHOW_WEB = this.getBooleanDebugOption("org.eclipse.update.core/debug/web", false);
            DEBUG_SHOW_IHANDLER = this.getBooleanDebugOption("org.eclipse.update.core/debug/installhandler", false);
            DEBUG_SHOW_RECONCILER = this.getBooleanDebugOption("org.eclipse.update.core/debug/reconciler", false);
        }
        try {
            File logFile = UpdateCore.getInstallLogFile();
            if (logFile != null) {
                log = new UpdateManagerLogWriter(logFile);
            }
        }
        catch (IOException e) {
            UpdateCore.warn("", e);
        }
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        JarContentReference.shutdown();
        Utilities.shutdown();
        if (log != null) {
            log.shutdown();
        }
        ConnectionThreadManagerFactory.getConnectionManager().shutdown();
        this.context = null;
        if (this.pkgAdminTracker != null) {
            this.pkgAdminTracker.close();
            this.pkgAdminTracker = null;
        }
        if (this.verifierFactoryTracker != null) {
            this.verifierFactoryTracker.close();
            this.verifierFactoryTracker = null;
        }
        if (this.proxyTracker != null) {
            this.proxyTracker.close();
            this.proxyTracker = null;
        }
    }

    BundleContext getBundleContext() {
        return this.context;
    }

    PackageAdmin getPackageAdmin() {
        if (this.pkgAdminTracker == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.osgi.service.packageadmin.PackageAdmin");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.pkgAdminTracker = new ServiceTracker(this.context, clazz.getName(), null);
            this.pkgAdminTracker.open();
        }
        return (PackageAdmin)this.pkgAdminTracker.getService();
    }

    public IProxyService getProxyService() {
        if (this.proxyTracker == null) {
            BundleContext bundleContext = this.getBundle().getBundleContext();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.core.net.proxy.IProxyService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.proxyTracker = new ServiceTracker(bundleContext, clazz.getName(), null);
            this.proxyTracker.open();
        }
        return (IProxyService)this.proxyTracker.getService();
    }

    public CertificateVerifierFactory getVerifierFactory() {
        if (this.verifierFactoryTracker == null) {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.osgi.internal.provisional.verifier.CertificateVerifierFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.verifierFactoryTracker = new ServiceTracker(this.context, clazz.getName(), null);
            this.verifierFactoryTracker.open();
        }
        return (CertificateVerifierFactory)this.verifierFactoryTracker.getService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdateSession getUpdateSession() {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.update.internal.core.UpdateSession");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (this.updateSession == null) {
                this.updateSession = new UpdateSession();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.updateSession;
        }
    }
}

