/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.cli.rest;

import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.remote.rest.RestConnector;
import com.savvytest.eclipse.runner.RunnerInformation;
import com.savvytest.eclipse.runner.connector.Connection;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.eclipse.core.runtime.NullProgressMonitor;

public class Runner {
    private String user;
    private String password;
    private final File inputArchive;
    private final File outputArchive;
    private final String url;

    public Runner(File inputArchive, File outputArchive, String url) {
        this.inputArchive = inputArchive;
        this.outputArchive = outputArchive;
        this.url = url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        Connection connection = new Connection();
        connection.setName("REST CLI");
        connection.setDescription("Command Line Interface runner for REST API tests.");
        connection.setConnectorId("com.savvytest.eclipse.remote.rest");
        Map<String, String> parameters = connection.getParameters();
        parameters.put("encoding", "UTF-8");
        parameters.put("user", this.getUser());
        parameters.put("password", this.getPassword());
        parameters.put("target", this.url);
        RunnerInformation info = new RunnerInformation();
        info.cleanUp = true;
        info.databaseReset = true;
        info.connection = connection;
        RestConnector connector = new RestConnector();
        connector.setRunnerInformation(info);
        InputStream in = null;
        OutputStream out = null;
        try {
            in = new BufferedInputStream(new FileInputStream(this.inputArchive));
            out = new BufferedOutputStream(new FileOutputStream(this.outputArchive));
            connector.run(in, out, new NullProgressMonitor());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    SavvytestSettings.INSTANCE.getLogger().log(e, (Object)this);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    SavvytestSettings.INSTANCE.getLogger().log(e, (Object)this);
                }
            }
        }
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

