/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.core.model.xml.properties.util;

import com.savvytest.eclipse.core.model.xml.data.Argument;
import com.savvytest.eclipse.core.model.xml.data.Array;
import com.savvytest.eclipse.core.model.xml.data.Data;
import com.savvytest.eclipse.core.model.xml.data.Number;
import com.savvytest.eclipse.core.model.xml.data.Struct;
import org.eclipse.emf.ecore.util.FeatureMap;

public class DataPrinter {
    public static String print(Argument arg) {
        StringBuilder sb = new StringBuilder();
        for (FeatureMap.Entry entry : arg.getParameters().getParameters()) {
            Data data = (Data)entry.getValue();
            DataPrinter.print(data, sb, "");
        }
        return sb.toString();
    }

    public static String print(Struct struct, String indent) {
        if (indent == null) {
            indent = "";
        }
        StringBuilder sb = new StringBuilder();
        DataPrinter.print(struct, sb, indent);
        return sb.toString();
    }

    public static String print(Struct struct, StringBuilder sb, String indent) {
        sb.append(indent).append(struct.getName()).append(" <struct>").append("\n");
        for (FeatureMap.Entry entry : struct.getElements()) {
            Data data = (Data)entry.getValue();
            DataPrinter.print(data, sb, String.valueOf(indent) + "  ");
        }
        return null;
    }

    public static String print(Array array, String indent) {
        if (indent == null) {
            indent = "";
        }
        StringBuilder sb = new StringBuilder();
        DataPrinter.print(array, sb, indent);
        return sb.toString();
    }

    public static String print(Array array, StringBuilder sb, String indent) {
        sb.append(indent).append(array.getName()).append(" <array>").append("\n");
        int i = 0;
        for (FeatureMap.Entry entry : array.getElements()) {
            Data data = (Data)entry.getValue();
            DataPrinter.print(data, sb, String.valueOf(indent) + " [" + i++ + "] ");
        }
        return null;
    }

    public static String print(Number number, String indent) {
        if (indent == null) {
            indent = "";
        }
        StringBuilder sb = new StringBuilder();
        DataPrinter.print(number, sb, indent);
        return sb.toString();
    }

    public static String print(Number number, StringBuilder sb, String indent) {
        sb.append(indent).append(number.getName()).append(" <number> = ").append("'").append(number.getValue()).append("'").append("\n");
        return null;
    }

    public static String print(com.savvytest.eclipse.core.model.xml.data.String string, String indent) {
        if (indent == null) {
            indent = "";
        }
        StringBuilder sb = new StringBuilder();
        DataPrinter.print(string, sb, indent);
        return sb.toString();
    }

    public static String print(com.savvytest.eclipse.core.model.xml.data.String string, StringBuilder sb, String indent) {
        sb.append(indent).append(string.getName()).append(" <string> = ").append("'").append(string.getValue()).append("'").append("\n");
        return null;
    }

    public static String print(Data data, StringBuilder sb, String indent) {
        if (data instanceof Array) {
            return DataPrinter.print((Array)data, sb, indent);
        }
        if (data instanceof Struct) {
            return DataPrinter.print((Struct)data, sb, indent);
        }
        if (data instanceof Number) {
            return DataPrinter.print((Number)data, sb, indent);
        }
        if (data instanceof com.savvytest.eclipse.core.model.xml.data.String) {
            return DataPrinter.print((com.savvytest.eclipse.core.model.xml.data.String)data, sb, indent);
        }
        return null;
    }
}

