/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.remote.rest;

import com.savvytest.eclipse.common.logging.LogLevel;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.core.model.xml.data.Argument;
import com.savvytest.eclipse.core.model.xml.data.Array;
import com.savvytest.eclipse.core.model.xml.data.Boolean;
import com.savvytest.eclipse.core.model.xml.data.Number;
import com.savvytest.eclipse.core.model.xml.data.String;
import com.savvytest.eclipse.core.model.xml.data.Struct;
import com.savvytest.eclipse.core.model.xml.data.impl.DataVisitorImpl;
import com.savvytest.eclipse.core.model.xml.properties.Properties;
import com.savvytest.eclipse.core.model.xml.properties.util.PropertiesUtils;
import com.savvytest.eclipse.core.model.xml.testcase.Testcase;
import com.savvytest.eclipse.core.model.xml.testcase.util.BuildTestcaseDataVisitor;
import com.savvytest.eclipse.remote.rest.RestConnector;
import java.math.BigDecimal;
import java.net.HttpURLConnection;

public class ResponseParserVisitor
extends DataVisitorImpl {
    private final HttpURLConnection connection;

    public ResponseParserVisitor(HttpURLConnection connection) {
        this.connection = connection;
    }

    @Override
    public Object visitOutput(Testcase testcase) throws Exception {
        int i = 0;
        while (i < testcase.getOutputUi().size()) {
            Properties ifaceProperties = ((com.savvytest.eclipse.core.model.xml.iface.Argument)testcase.getInterface().getArguments().get(i)).getProperties();
            if (RestConnector.PropertyArgumentUsageTarget.RESPONSE.name().equals(PropertiesUtils.getStringProperty(ifaceProperties, PropertiesUtils.PropertyEnum.USAGE_TARGET))) {
                this.visit((Argument)testcase.getOutputUi().get(i));
                BuildTestcaseDataVisitor testDataVisitor = new BuildTestcaseDataVisitor((Argument)testcase.getOutputUi().get(i), "output.arg" + i, true);
                ((com.savvytest.eclipse.core.model.xml.testcase.Argument)testcase.getOutput().get(i)).getDatas().addAll(testDataVisitor.getTestcaseData());
            }
            ++i;
        }
        return null;
    }

    @Override
    public Object visit(Struct struct) throws Exception {
        SavvytestSettings.INSTANCE.getLogger().log("Unexpected instance of 'Struct' found in RESPONSE structure. ID of structure: " + struct.calculateOutputId(), LogLevel.WARNING, this);
        return null;
    }

    @Override
    public Object visit(Array array) throws Exception {
        SavvytestSettings.INSTANCE.getLogger().log("Unexpected instance of 'Array' found in RESPONSE structure. ID of array: " + array.calculateOutputId(), LogLevel.WARNING, this);
        return null;
    }

    @Override
    public Object visit(String string) throws Exception {
        if (string.getName().equals("responseMessage")) {
            string.setValue(this.connection.getResponseMessage());
            return null;
        }
        java.lang.String value = this.connection.getHeaderField(string.getName());
        if (value != null) {
            string.setValue(value);
        }
        return null;
    }

    @Override
    public Object visit(Number number) throws Exception {
        if (number.getName().equals("responseCode")) {
            number.setValue(BigDecimal.valueOf(this.connection.getResponseCode()));
            return null;
        }
        java.lang.String value = this.connection.getHeaderField(number.getName());
        if (value != null) {
            try {
                number.setValue(new BigDecimal(value));
            }
            catch (NumberFormatException e) {
                SavvytestSettings.INSTANCE.getLogger().log(e, (Object)this);
            }
        }
        return null;
    }

    @Override
    public Object visit(Boolean bool) throws Exception {
        java.lang.String value = this.connection.getHeaderField(bool.getName());
        if (value != null) {
            bool.setValue(java.lang.Boolean.valueOf(value));
        }
        return null;
    }
}

