/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.runner.connector;

import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.runner.connector.IConnection;
import com.savvytest.eclipse.runner.connector.IConnectionParameterProvider;
import com.savvytest.eclipse.runner.connector.IConnector;
import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class ConnectorExtensionPointInformation {
    private static final String CONNECTOR_EXTENSION_POINT_ID = "com.savvytest.connector";
    private static final String CONNECTOR_EXTENSION_ID = "id";
    private static final String CONNECTOR_EXTENSION_NAME = "name";
    private static final String CONNECTOR_EXTENSION_SHORT_NAME = "shortName";
    private static final String CONNECTOR_EXTENSION_CONNECTOR = "connector";
    private static final String CONNECTOR_EXTENSION_CONNECTION = "connection";
    private static final String CONNECTOR_EXTENSION_PARAMETER_PROVIDER = "parameterProvider";
    private static ConnectorExtensionPointInformation[] informations;
    public final Class<? extends IConnector> connectorClass;
    public final Class<? extends IConnection> connectionClass;
    public final Class<? extends IConnectionParameterProvider> parameterProviderClass;
    public final String id;
    public final String name;
    public final String shortName;

    public static final ConnectorExtensionPointInformation[] getInformations() {
        if (informations == null) {
            IConfigurationElement[] connectionElements = Platform.getExtensionRegistry().getConfigurationElementsFor(CONNECTOR_EXTENSION_POINT_ID);
            ArrayList<ConnectorExtensionPointInformation> informations = new ArrayList<ConnectorExtensionPointInformation>(connectionElements.length);
            IConfigurationElement[] iConfigurationElementArray = connectionElements;
            int n = connectionElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                String id = element.getAttribute(CONNECTOR_EXTENSION_ID);
                String name = element.getAttribute(CONNECTOR_EXTENSION_NAME);
                String shortName = element.getAttribute(CONNECTOR_EXTENSION_SHORT_NAME);
                try {
                    Bundle bundle = Platform.getBundle(element.getContributor().getName());
                    Class<?> connectorClass = bundle.loadClass(element.getAttribute(CONNECTOR_EXTENSION_CONNECTOR));
                    Class<?> connectionClass = bundle.loadClass(element.getAttribute(CONNECTOR_EXTENSION_CONNECTION));
                    Class<?> parameterProviderClass = bundle.loadClass(element.getAttribute(CONNECTOR_EXTENSION_PARAMETER_PROVIDER));
                    ConnectorExtensionPointInformation information = new ConnectorExtensionPointInformation(id, name, shortName, connectorClass, connectionClass, parameterProviderClass);
                    informations.add(information);
                }
                catch (Exception e) {
                    SavvytestSettings.INSTANCE.getLogger().log(e, ConnectorExtensionPointInformation.class);
                }
                ++n2;
            }
            ConnectorExtensionPointInformation.informations = informations.toArray(new ConnectorExtensionPointInformation[informations.size()]);
        }
        return informations;
    }

    public static final ConnectorExtensionPointInformation getInformation(String connectorId) {
        if (connectorId == null) {
            return null;
        }
        ConnectorExtensionPointInformation[] connectorExtensionPointInformationArray = ConnectorExtensionPointInformation.getInformations();
        int n = connectorExtensionPointInformationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ConnectorExtensionPointInformation information = connectorExtensionPointInformationArray[n2];
            if (connectorId.equals(information.id)) {
                return information;
            }
            ++n2;
        }
        return null;
    }

    private ConnectorExtensionPointInformation(String id, String name, String shortName, Class<? extends IConnector> connectorClass, Class<? extends IConnection> connectionClass, Class<? extends IConnectionParameterProvider> parameterProviderClass) {
        this.id = id;
        this.name = name;
        this.shortName = shortName;
        this.connectorClass = connectorClass;
        this.connectionClass = connectionClass;
        this.parameterProviderClass = parameterProviderClass;
    }

    public IConnector createConnector() {
        try {
            return this.connectorClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            SavvytestSettings.INSTANCE.getLogger().log(e, (Object)this);
            return null;
        }
    }

    public IConnection createConnection() {
        try {
            IConnection connection = this.connectionClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            connection.setConnectorId(this.id);
            return connection;
        }
        catch (Exception e) {
            SavvytestSettings.INSTANCE.getLogger().log(e, (Object)this);
            return null;
        }
    }

    public IConnectionParameterProvider createParameterProvider() {
        try {
            return this.parameterProviderClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            SavvytestSettings.INSTANCE.getLogger().log(e, (Object)this);
            return null;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ConnectorExtensionPointInformation [connectorClass=");
        builder.append(this.connectorClass);
        builder.append(", connectionClass=");
        builder.append(this.connectionClass);
        builder.append(", parameterProviderClass=");
        builder.append(this.parameterProviderClass);
        builder.append(", id=");
        builder.append(this.id);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", shortName=");
        builder.append(this.shortName);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.connectionClass == null ? 0 : this.connectionClass.hashCode());
        result = 31 * result + (this.connectorClass == null ? 0 : this.connectorClass.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.parameterProviderClass == null ? 0 : this.parameterProviderClass.hashCode());
        result = 31 * result + (this.shortName == null ? 0 : this.shortName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConnectorExtensionPointInformation other = (ConnectorExtensionPointInformation)obj;
        if (this.connectionClass == null ? other.connectionClass != null : !this.connectionClass.equals(other.connectionClass)) {
            return false;
        }
        if (this.connectorClass == null ? other.connectorClass != null : !this.connectorClass.equals(other.connectorClass)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.parameterProviderClass == null ? other.parameterProviderClass != null : !this.parameterProviderClass.equals(other.parameterProviderClass)) {
            return false;
        }
        return !(this.shortName == null ? other.shortName != null : !this.shortName.equals(other.shortName));
    }
}

