/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.misc.CheckboxTreeAndListGroup;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ResourceSelectionDialog
extends SelectionDialog {
    private IAdaptable root;
    private CheckboxTreeAndListGroup selectionGroup;
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 400;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 300;

    public ResourceSelectionDialog(Shell parentShell, IAdaptable rootElement, String message) {
        super(parentShell);
        this.setTitle(IDEWorkbenchMessages.ResourceSelectionDialog_title);
        this.root = rootElement;
        if (message != null) {
            this.setMessage(message);
        } else {
            this.setMessage(IDEWorkbenchMessages.ResourceSelectionDialog_message);
        }
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    private void checkInitialSelections() {
        Iterator itemsToCheck = this.getInitialElementSelections().iterator();
        while (itemsToCheck.hasNext()) {
            IResource currentElement = (IResource)itemsToCheck.next();
            if (currentElement.getType() == 1) {
                this.selectionGroup.initialCheckListItem(currentElement);
                continue;
            }
            this.selectionGroup.initialCheckTreeItem(currentElement);
        }
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        this.getOkButton().setEnabled(this.selectionGroup.getCheckedElementCount() > 0);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.ide.resource_selection_dialog_context");
    }

    public void create() {
        super.create();
        this.initializeDialog();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        ArrayList<IAdaptable> input = new ArrayList<IAdaptable>();
        input.add(this.root);
        this.createMessageArea(composite);
        this.selectionGroup = new CheckboxTreeAndListGroup(composite, input, this.getResourceProvider(14), WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider(), this.getResourceProvider(1), WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider(), 0, 400, 300);
        composite.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                TableColumn[] columns = ResourceSelectionDialog.this.selectionGroup.getListTable().getColumns();
                int i = 0;
                while (i < columns.length) {
                    columns[i].pack();
                    ++i;
                }
            }
        });
        return composite;
    }

    private ITreeContentProvider getResourceProvider(final int resourceType) {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                if (o instanceof IContainer) {
                    IResource[] members = null;
                    try {
                        members = ((IContainer)o).members();
                    }
                    catch (CoreException coreException) {
                        return new Object[0];
                    }
                    ArrayList<IResource> results = new ArrayList<IResource>();
                    int i = 0;
                    while (i < members.length) {
                        if ((members[i].getType() & resourceType) > 0) {
                            results.add(members[i]);
                        }
                        ++i;
                    }
                    return results.toArray();
                }
                if (o instanceof ArrayList) {
                    return ((ArrayList)o).toArray();
                }
                return new Object[0];
            }
        };
    }

    private void initializeDialog() {
        this.selectionGroup.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ResourceSelectionDialog.this.getOkButton().setEnabled(ResourceSelectionDialog.this.selectionGroup.getCheckedElementCount() > 0);
            }
        });
        if (this.getInitialElementSelections().isEmpty()) {
            this.getOkButton().setEnabled(false);
        } else {
            this.checkInitialSelections();
        }
    }

    protected void okPressed() {
        Iterator resultEnum = this.selectionGroup.getAllCheckedListItems();
        ArrayList list = new ArrayList();
        while (resultEnum.hasNext()) {
            list.add(resultEnum.next());
        }
        this.setResult(list);
        super.okPressed();
    }
}

