/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener2;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.internal.ObjectActionContributorManager;
import org.eclipse.ui.internal.PluginActionContributionItem;
import org.eclipse.ui.internal.ViewerActionBuilder;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.menus.WindowMenuService;
import org.eclipse.ui.menus.IMenuService;

public class PopupMenuExtender
implements IMenuListener2,
IRegistryChangeListener {
    private static final int STATIC_ACTION_READ = 1;
    private static final int INCLUDE_EDITOR_INPUT = 2;
    private final MenuManager menu;
    private SubMenuManager menuWrapper;
    private final ISelectionProvider selProvider;
    private final IWorkbenchPart part;
    private Map staticActionBuilders = null;
    private int bitSet = 0;
    private ArrayList contributionCache = new ArrayList();
    private boolean contributionsPopulated = false;
    static /* synthetic */ Class class$0;

    public PopupMenuExtender(String id, MenuManager menu, ISelectionProvider prov, IWorkbenchPart part) {
        this(id, menu, prov, part, true);
    }

    public PopupMenuExtender(String id, MenuManager menu, ISelectionProvider prov, IWorkbenchPart part, boolean includeEditorInput) {
        this.menu = menu;
        this.selProvider = prov;
        this.part = part;
        if (includeEditorInput) {
            this.bitSet |= 2;
        }
        menu.addMenuListener(this);
        if (!menu.getRemoveAllWhenShown()) {
            this.menuWrapper = new SubMenuManager(menu);
            this.menuWrapper.setVisible(true);
        }
        this.readStaticActionsFor(id);
        Platform.getExtensionRegistry().addRegistryChangeListener(this);
    }

    public Set getMenuIds() {
        if (this.staticActionBuilders == null) {
            return Collections.EMPTY_SET;
        }
        return this.staticActionBuilders.keySet();
    }

    public final void addMenuId(String menuId) {
        this.bitSet &= 0xFFFFFFFE;
        this.readStaticActionsFor(menuId);
    }

    public final boolean matches(MenuManager menuManager, ISelectionProvider selectionProvider, IWorkbenchPart part) {
        return this.menu == menuManager && this.selProvider == selectionProvider && this.part == part;
    }

    private void addEditorActions(IMenuManager mgr) {
        ISelectionProvider activeEditor = new ISelectionProvider(){

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
                throw new UnsupportedOperationException("This ISelectionProvider is static, and cannot be modified.");
            }

            public ISelection getSelection() {
                if (PopupMenuExtender.this.part instanceof IEditorPart) {
                    IEditorPart editorPart = (IEditorPart)PopupMenuExtender.this.part;
                    return new StructuredSelection(new Object[]{editorPart.getEditorInput()});
                }
                return new StructuredSelection(new Object[0]);
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
                throw new UnsupportedOperationException("This ISelectionProvider is static, and cannot be modified.");
            }

            public void setSelection(ISelection selection) {
                throw new UnsupportedOperationException("This ISelectionProvider is static, and cannot be modified.");
            }
        };
        if (ObjectActionContributorManager.getManager().contributeObjectActions(this.part, mgr, activeEditor)) {
            mgr.add(new Separator());
        }
    }

    private void addObjectActions(IMenuManager mgr) {
        if (this.selProvider != null && ObjectActionContributorManager.getManager().contributeObjectActions(this.part, mgr, this.selProvider)) {
            mgr.add(new Separator());
        }
    }

    private final void clearStaticActions() {
        this.bitSet &= 0xFFFFFFFE;
        if (this.staticActionBuilders != null) {
            Iterator staticActionBuilderItr = this.staticActionBuilders.values().iterator();
            while (staticActionBuilderItr.hasNext()) {
                Object staticActionBuilder = staticActionBuilderItr.next();
                if (!(staticActionBuilder instanceof ViewerActionBuilder)) continue;
                ((ViewerActionBuilder)staticActionBuilder).dispose();
            }
        }
    }

    private void addStaticActions(IMenuManager mgr) {
        if (this.staticActionBuilders != null) {
            Iterator staticActionBuilderItr = this.staticActionBuilders.values().iterator();
            while (staticActionBuilderItr.hasNext()) {
                ViewerActionBuilder staticActionBuilder = (ViewerActionBuilder)staticActionBuilderItr.next();
                staticActionBuilder.contribute(mgr, null, true);
            }
        }
    }

    public void menuAboutToShow(IMenuManager mgr) {
        IWorkbench workbench;
        IMenuManager originalManager = mgr;
        IWorkbenchPartSite site = this.part.getSite();
        if (site != null && (workbench = site.getWorkbenchWindow().getWorkbench()) instanceof Workbench) {
            Workbench realWorkbench = (Workbench)workbench;
            StructuredSelection input = null;
            if ((this.bitSet & 2) != 0 && this.part instanceof IEditorPart) {
                IEditorPart editorPart = (IEditorPart)this.part;
                input = new StructuredSelection(new Object[]{editorPart.getEditorInput()});
            }
            ISelection s = this.selProvider == null ? null : this.selProvider.getSelection();
            realWorkbench.addShowingMenus(this.getMenuIds(), s, input);
        }
        this.readStaticActions();
        this.testForAdditions();
        if (this.menuWrapper != null) {
            mgr = this.menuWrapper;
            this.menuWrapper.removeAll();
        }
        this.addMenuContributions(originalManager);
        if ((this.bitSet & 2) != 0) {
            this.addEditorActions(mgr);
        }
        this.addObjectActions(mgr);
        this.addStaticActions(mgr);
        this.cleanUpContributionCache();
    }

    private void addMenuContributions(IMenuManager mgr) {
        IMenuService menuService;
        IWorkbenchPartSite iWorkbenchPartSite = this.part.getSite();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.menus.IMenuService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((menuService = (IMenuService)iWorkbenchPartSite.getService(clazz)) == null) {
            return;
        }
        if ((mgr.getRemoveAllWhenShown() || !this.contributionsPopulated) && mgr instanceof ContributionManager) {
            ContributionManager manager = (ContributionManager)((Object)mgr);
            this.contributionsPopulated = true;
            menuService.populateContributionManager(manager, "popup:org.eclipse.ui.popup.any");
            Iterator i = this.getMenuIds().iterator();
            WindowMenuService realService = (WindowMenuService)menuService;
            while (i.hasNext()) {
                String id = "popup:" + i.next();
                realService.populateContributionManager(manager, id, false);
            }
        }
    }

    public final void menuAboutToHide(IMenuManager mgr) {
        IWorkbench workbench;
        this.gatherContributions(mgr);
        IWorkbenchPartSite site = this.part.getSite();
        if (site != null && (workbench = site.getWorkbenchWindow().getWorkbench()) instanceof Workbench) {
            workbench.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    Workbench realWorkbench = (Workbench)workbench;
                    realWorkbench.removeShowingMenus(PopupMenuExtender.this.getMenuIds(), null, null);
                }
            });
        }
    }

    private void gatherContributions(IMenuManager mgr) {
        IContributionItem[] items = mgr.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i] instanceof PluginActionContributionItem) {
                this.contributionCache.add(items[i]);
            } else if (items[i] instanceof IMenuManager) {
                this.gatherContributions((IMenuManager)items[i]);
            }
            ++i;
        }
    }

    private void cleanUpContributionCache() {
        PluginActionContributionItem[] items = this.contributionCache.toArray(new PluginActionContributionItem[this.contributionCache.size()]);
        this.contributionCache.clear();
        int i = 0;
        while (i < items.length) {
            items[i].dispose();
            ++i;
        }
    }

    private final void readStaticActions() {
        if (this.staticActionBuilders != null) {
            Iterator menuIdItr = this.staticActionBuilders.keySet().iterator();
            while (menuIdItr.hasNext()) {
                String menuId = (String)menuIdItr.next();
                this.readStaticActionsFor(menuId);
            }
        }
    }

    private void readStaticActionsFor(String menuId) {
        Object object;
        if ((this.bitSet & 1) != 0) {
            return;
        }
        this.bitSet |= 1;
        if (menuId == null || menuId.length() < 1) {
            return;
        }
        if (this.staticActionBuilders == null) {
            this.staticActionBuilders = new HashMap();
        }
        if (!((object = this.staticActionBuilders.get(menuId)) instanceof ViewerActionBuilder)) {
            object = new ViewerActionBuilder();
            this.staticActionBuilders.put(menuId, object);
        }
        ViewerActionBuilder staticActionBuilder = (ViewerActionBuilder)object;
        staticActionBuilder.readViewerContributions(menuId, this.selProvider, this.part);
    }

    private void testForAdditions() {
        IContributionItem item = this.menu.find("additions");
        if (item == null) {
            WorkbenchPlugin.log("Context menu missing standard group 'org.eclipse.ui.IWorkbenchActionConstants.MB_ADDITIONS'. (menu ids = " + this.getMenuIds().toString() + ")  part id = " + (this.part == null ? "???" : this.part.getSite().getId()) + ")");
        }
    }

    public void dispose() {
        IMenuService menuService;
        this.clearStaticActions();
        IWorkbenchPartSite iWorkbenchPartSite = this.part.getSite();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.menus.IMenuService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((menuService = (IMenuService)iWorkbenchPartSite.getService(clazz)) != null) {
            menuService.releaseContributions(this.menu);
        }
        Platform.getExtensionRegistry().removeRegistryChangeListener(this);
        this.menu.removeMenuListener(this);
    }

    public void registryChanged(IRegistryChangeEvent event) {
        Display display = Display.getDefault();
        if (this.part != null) {
            display = this.part.getSite().getPage().getWorkbenchWindow().getWorkbench().getDisplay();
        }
        IExtensionDelta[] deltas = event.getExtensionDeltas();
        int i = 0;
        while (i < deltas.length) {
            IExtensionDelta delta = deltas[i];
            IExtensionPoint extensionPoint = delta.getExtensionPoint();
            if (extensionPoint.getNamespace().equals(WorkbenchPlugin.PI_WORKBENCH) && extensionPoint.getSimpleIdentifier().equals("popupMenus")) {
                boolean clearPopups = false;
                IConfigurationElement[] elements = delta.getExtension().getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    IConfigurationElement element = elements[j];
                    if (element.getName().equals("viewerContribution")) {
                        clearPopups = true;
                        break;
                    }
                    ++j;
                }
                if (clearPopups) {
                    display.syncExec(new Runnable(){

                        public void run() {
                            PopupMenuExtender.this.clearStaticActions();
                        }
                    });
                }
            }
            ++i;
        }
    }

    public MenuManager getManager() {
        return this.menu;
    }
}

