/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.statushandlers;

import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.eclipse.ui.internal.progress.ProgressManagerUtil;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.internal.statushandlers.StatusNotificationManager;
import org.eclipse.ui.progress.IProgressConstants;
import org.eclipse.ui.statushandlers.StatusAdapter;

public class StatusDialog
extends ErrorDialog {
    private static final String PREF_SKIP_GOTO_ACTION_PROMPT = "pref_skip_goto_action_prompt";
    private static final int GOTO_ACTION_ID = 1025;
    private TableViewer statusListViewer;
    private StatusNotificationManager.StatusInfo selectedStatus;
    static /* synthetic */ Class class$0;

    public StatusDialog(Shell parentShell, StatusNotificationManager.StatusInfo statusInfo, int displayMask, boolean modal) {
        super(parentShell, (String)statusInfo.getStatus().getProperty(StatusAdapter.TITLE_PROPERTY), statusInfo.getStatus().getStatus().getMessage(), statusInfo.getStatus().getStatus(), displayMask);
        this.setShellStyle(0x90 | this.getShellStyle());
        this.selectedStatus = statusInfo;
        this.setBlockOnOpen(false);
        if (!modal) {
            this.setShellStyle(0xFFFEFFFF & this.getShellStyle());
        }
        String reason = WorkbenchMessages.StatusDialog_checkDetailsMessage;
        if (statusInfo.getStatus().getStatus().getException() != null) {
            reason = statusInfo.getStatus().getStatus().getException().getMessage() == null ? statusInfo.getStatus().getStatus().getException().toString() : statusInfo.getStatus().getStatus().getException().getMessage();
        }
        this.message = NLS.bind(WorkbenchMessages.StatusDialog_reason, new Object[]{statusInfo.getDisplayString(), reason});
    }

    void refresh() {
        if (AUTOMATED_MODE) {
            return;
        }
        if (this.dialogArea == null || this.dialogArea.isDisposed()) {
            return;
        }
        if (this.isMultipleStatusDialog()) {
            if (this.statusListViewer == null) {
                this.setMessage(ProgressMessages.JobErrorDialog_MultipleErrorsMessage);
                this.getShell().setText(ProgressMessages.JobErrorDialog_MultipleErrorsTitle);
                this.createStatusListArea((Composite)this.dialogArea);
                this.showDetailsArea();
            }
            this.refreshStatusList();
        }
        this.updateEnablements();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        IAction gotoAction = this.getGotoAction();
        String text = null;
        if (gotoAction != null) {
            text = gotoAction.getText();
        }
        if (text == null) {
            text = ProgressMessages.JobErrorDialog_CustomJobText;
        }
        this.createButton(parent, 1025, text, false);
        super.createButtonsForButtonBar(parent);
    }

    private void updateEnablements() {
        Button gotoButton;
        Button details = this.getButton(13);
        if (details != null) {
            details.setEnabled(true);
        }
        if ((gotoButton = this.getButton(1025)) != null) {
            IAction gotoAction = this.getGotoAction();
            boolean hasValidGotoAction = gotoAction != null;
            String text = gotoButton.getText();
            String newText = null;
            if (hasValidGotoAction) {
                newText = gotoAction.getText();
            }
            if (newText == null) {
                hasValidGotoAction = false;
                newText = ProgressMessages.JobErrorDialog_CustomJobText;
            }
            if (!newText.equals(text)) {
                gotoButton.setText(newText);
            }
            gotoButton.setEnabled(hasValidGotoAction);
            gotoButton.setVisible(hasValidGotoAction);
        }
    }

    protected void buttonPressed(int id) {
        IAction gotoAction;
        if (id == 1025 && (gotoAction = this.getGotoAction()) != null && (!this.isMultipleStatusDialog() || this.isPromptToClose())) {
            this.okPressed();
            gotoAction.run();
        }
        super.buttonPressed(id);
    }

    public boolean isModal() {
        return (this.getShellStyle() & 0x10000) == 65536;
    }

    private boolean isPromptToClose() {
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        if (!store.contains(PREF_SKIP_GOTO_ACTION_PROMPT) || !store.getString(PREF_SKIP_GOTO_ACTION_PROMPT).equals("always")) {
            MessageDialogWithToggle dialog = MessageDialogWithToggle.openOkCancelConfirm(this.getShell(), ProgressMessages.JobErrorDialog_CloseDialogTitle, ProgressMessages.JobErrorDialog_CloseDialogMessage, ProgressMessages.JobErrorDialog_DoNotShowAgainMessage, false, store, PREF_SKIP_GOTO_ACTION_PROMPT);
            return dialog.getReturnCode() == 0;
        }
        return true;
    }

    private IAction getGotoAction() {
        Job job;
        Object property = null;
        StatusAdapter statusAdapter = this.selectedStatus.getStatus();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.runtime.jobs.Job");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((job = (Job)statusAdapter.getAdapter(clazz)) != null) {
            property = job.getProperty(IProgressConstants.ACTION_PROPERTY);
        }
        if (property instanceof IAction) {
            return (IAction)property;
        }
        return null;
    }

    private void setMessage(String messageString) {
        String string = this.message = messageString == null ? "" : messageString;
        if (this.messageLabel == null || this.messageLabel.isDisposed()) {
            return;
        }
        this.messageLabel.setText(this.message);
    }

    private void createStatusListArea(Composite parent) {
        this.statusListViewer = new TableViewer(parent, 2820);
        this.statusListViewer.setComparator(this.getViewerComparator());
        Control control = this.statusListViewer.getControl();
        GridData data = new GridData(1808);
        data.heightHint = this.convertHeightInCharsToPixels(10);
        control.setLayoutData((Object)data);
        this.initContentProvider();
        this.initLabelProvider();
        this.statusListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StatusDialog.this.handleSelectionChange();
            }
        });
        StatusDialog.applyDialogFont((Control)parent);
    }

    private boolean isMultipleStatusDialog() {
        return this.getManager().getErrors().size() > 1;
    }

    private StatusNotificationManager getManager() {
        return StatusNotificationManager.getInstance();
    }

    public StatusNotificationManager.StatusInfo getSelectedError() {
        return this.selectedStatus;
    }

    private ViewerComparator getViewerComparator() {
        return new ViewerComparator(){

            public int compare(Viewer testViewer, Object e1, Object e2) {
                return ((Comparable)e1).compareTo(e2);
            }
        };
    }

    protected void initContentProvider() {
        IStructuredContentProvider provider = new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return StatusDialog.this.getManager().getErrors().toArray();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                if (newInput != null) {
                    StatusDialog.this.refreshStatusList();
                }
            }
        };
        this.statusListViewer.setContentProvider(provider);
        this.statusListViewer.setInput(this.getManager());
        this.statusListViewer.setSelection(new StructuredSelection(this.selectedStatus));
    }

    void refreshStatusList() {
        if (this.statusListViewer != null && !this.statusListViewer.getControl().isDisposed()) {
            this.statusListViewer.refresh();
            Point newSize = this.getShell().computeSize(-1, -1);
            this.getShell().setSize(newSize);
        }
        this.setStatus(this.selectedStatus.getStatus().getStatus());
    }

    private void initLabelProvider() {
        ITableLabelProvider provider = new ITableLabelProvider(){
            Map imageTable = new HashMap();

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
                if (!this.imageTable.isEmpty()) {
                    Iterator iter = this.imageTable.values().iterator();
                    while (iter.hasNext()) {
                        Image image = (Image)iter.next();
                        image.dispose();
                    }
                }
            }

            public Image getColumnImage(Object element, int columnIndex) {
                if (element != null) {
                    Job job;
                    StatusAdapter statusAdapter = ((StatusNotificationManager.StatusInfo)element).getStatus();
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.core.runtime.jobs.Job");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((job = (Job)statusAdapter.getAdapter(clazz)) != null) {
                        return this.getIcon(job);
                    }
                }
                return null;
            }

            private Image getIcon(Job job) {
                if (job != null) {
                    Object property = job.getProperty(IProgressConstants.ICON_PROPERTY);
                    Image im = (Image)this.imageTable.get(property);
                    if (im != null) {
                        return im;
                    }
                    Display display = StatusDialog.this.getShell().getDisplay();
                    if (property instanceof ImageDescriptor) {
                        im = ((ImageDescriptor)property).createImage((Device)display);
                        this.imageTable.put(property, im);
                    } else if (property instanceof URL) {
                        im = ImageDescriptor.createFromURL((URL)property).createImage((Device)display);
                        this.imageTable.put(property, im);
                    } else {
                        im = ProgressManager.getInstance().getIconFor(job);
                    }
                    return im;
                }
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                return ((StatusNotificationManager.StatusInfo)element).getDisplayString();
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        };
        this.statusListViewer.setLabelProvider(provider);
    }

    private StatusNotificationManager.StatusInfo getSingleSelection() {
        IStructuredSelection selection;
        ISelection rawSelection = this.statusListViewer.getSelection();
        if (rawSelection != null && rawSelection instanceof IStructuredSelection && (selection = (IStructuredSelection)rawSelection).size() == 1) {
            return (StatusNotificationManager.StatusInfo)selection.getFirstElement();
        }
        return null;
    }

    public boolean close() {
        Rectangle shellPosition = this.getShell().getBounds();
        boolean result = super.close();
        ProgressManagerUtil.animateDown(shellPosition);
        return result;
    }

    public int open() {
        int result = super.open();
        this.setStatus(this.selectedStatus.getStatus().getStatus());
        return result;
    }

    protected void initializeBounds() {
        this.refresh();
        super.initializeBounds();
        Rectangle shellPosition = this.getShell().getBounds();
        ProgressManagerUtil.animateUp(shellPosition);
    }

    void handleSelectionChange() {
        StatusNotificationManager.StatusInfo newSelection = this.getSingleSelection();
        if (newSelection != null && newSelection != this.selectedStatus) {
            this.selectedStatus = newSelection;
            this.setStatus(this.selectedStatus.getStatus().getStatus());
            this.updateEnablements();
            this.showDetailsArea();
        }
    }

    protected boolean shouldShowDetailsButton() {
        return true;
    }
}

