/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.bookmarkexplorer;

import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.DeleteMarkersOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.views.bookmarkexplorer.BookmarkMessages;
import org.eclipse.ui.views.bookmarkexplorer.BookmarkAction;
import org.eclipse.ui.views.bookmarkexplorer.BookmarkNavigator;

class RemoveBookmarkAction
extends BookmarkAction {
    public RemoveBookmarkAction(BookmarkNavigator view) {
        super(view, BookmarkMessages.RemoveBookmark_text);
        this.setToolTipText(BookmarkMessages.RemoveBookmark_toolTip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this, "org.eclipse.ui.remove_bookmark_action_context");
        this.setEnabled(false);
    }

    public void run() {
        IStructuredSelection sel = this.getStructuredSelection();
        if (sel.isEmpty()) {
            return;
        }
        List list = sel.toList();
        IMarker[] markers = new IMarker[list.size()];
        list.toArray(markers);
        DeleteMarkersOperation op = new DeleteMarkersOperation(markers, BookmarkMessages.RemoveBookmark_undoText);
        this.execute(op, BookmarkMessages.RemoveBookmark_errorTitle, null, WorkspaceUndoUtil.getUIInfoAdapter(this.getView().getShell()));
    }

    public void selectionChanged(IStructuredSelection sel) {
        this.setEnabled(!sel.isEmpty());
    }
}

