/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.configuration.ILocalSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.ui.RestartDialog;
import org.eclipse.update.internal.ui.URLCoder;
import org.eclipse.update.internal.ui.UpdateLabelProvider;
import org.eclipse.update.internal.ui.model.UpdateModel;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class UpdateUI
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.update.ui";
    public static final String WEB_APP_ID = "org.eclipse.update";
    public static final String P_DISCOVERY_SITES_ENABLED = "discoverySitesEnabled";
    private static UpdateUI plugin;
    private UpdateModel model;
    private String appServerHost;
    private int appServerPort;
    private UpdateLabelProvider labelProvider;
    private static boolean remindOnCancel;

    static {
        remindOnCancel = true;
    }

    public UpdateUI() {
        plugin = this;
    }

    public static UpdateUI getDefault() {
        return plugin;
    }

    public static IWorkbenchPage getActivePage() {
        return UpdateUI.getDefault().internalGetActivePage();
    }

    private IWorkbenchPage internalGetActivePage() {
        IWorkbenchWindow window = this.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            return window.getActivePage();
        }
        return null;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = UpdateUI.getActiveWorkbenchWindow();
        return window != null ? window.getShell() : UpdateUI.getStandardDisplay().getActiveShell();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return UpdateUI.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static String getPluginId() {
        return UpdateUI.getDefault().getBundle().getSymbolicName();
    }

    public UpdateLabelProvider getLabelProvider() {
        if (this.labelProvider == null) {
            this.labelProvider = new UpdateLabelProvider();
        }
        return this.labelProvider;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.model = new UpdateModel();
        int historyPref = this.getPluginPreferences().getInt("org.eclipse.update.core.historySize");
        if (historyPref > 0) {
            UpdateCore.DEFAULT_HISTORY = historyPref;
        }
    }

    public boolean isWebAppStarted() {
        return this.appServerHost != null;
    }

    public String getAppServerHost() {
        return this.appServerHost;
    }

    public int getAppServerPort() {
        return this.appServerPort;
    }

    public void stop(BundleContext context) throws Exception {
        if (this.model != null) {
            this.model.shutdown();
        }
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
        }
        super.stop(context);
    }

    public UpdateModel getUpdateModel() {
        return this.model;
    }

    public static void logException(Throwable e) {
        UpdateUI.logException(e, true);
    }

    public static void logException(Throwable e, boolean showErrorDialog) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        IStatus status = null;
        if (e instanceof CoreException) {
            status = ((CoreException)e).getStatus();
        } else {
            String message = e.getMessage();
            if (message == null) {
                message = e.toString();
            }
            status = new Status(4, UpdateUI.getPluginId(), 0, message, e);
        }
        UpdateUI.log(status, showErrorDialog);
    }

    public static void log(IStatus status, boolean showErrorDialog) {
        if (status.getSeverity() != 1) {
            if (showErrorDialog) {
                ErrorDialog.openError(UpdateUI.getActiveWorkbenchShell(), null, null, status);
            }
            Bundle bundle = Platform.getBundle(PLUGIN_ID);
            Platform.getLog(bundle).log(status);
        } else {
            MessageDialog.openInformation(UpdateUI.getActiveWorkbenchShell(), null, status.getMessage());
        }
    }

    public static IFeature[] searchSite(String featureId, IConfiguredSite site, boolean onlyConfigured) throws CoreException {
        IFeatureReference[] references = null;
        references = onlyConfigured ? site.getConfiguredFeatures() : site.getSite().getFeatureReferences();
        Vector<IFeature> result = new Vector<IFeature>();
        int i = 0;
        while (i < references.length) {
            IFeature feature = references[i].getFeature(null);
            String id = feature.getVersionedIdentifier().getIdentifier();
            if (featureId.equals(id)) {
                result.add(feature);
            }
            ++i;
        }
        return result.toArray(new IFeature[result.size()]);
    }

    public static IFeature[] getInstalledFeatures(IFeature feature) {
        return UpdateUI.getInstalledFeatures(feature, true);
    }

    public static IFeature[] getInstalledFeatures(IFeature feature, boolean onlyConfigured) {
        Vector<IFeature> features = new Vector<IFeature>();
        try {
            ILocalSite localSite = SiteManager.getLocalSite();
            IInstallConfiguration config = localSite.getCurrentConfiguration();
            IConfiguredSite[] isites = config.getConfiguredSites();
            VersionedIdentifier vid = feature.getVersionedIdentifier();
            String id = vid.getIdentifier();
            int i = 0;
            while (i < isites.length) {
                IConfiguredSite isite = isites[i];
                IFeature[] result = UpdateUI.searchSite(id, isite, onlyConfigured);
                int j = 0;
                while (j < result.length) {
                    IFeature installedFeature = result[j];
                    features.add(installedFeature);
                    ++j;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            UpdateUI.logException(e);
        }
        return features.toArray(new IFeature[features.size()]);
    }

    public static URL getOriginatingURL(String id) {
        IDialogSettings section = UpdateUI.getOriginatingURLSection();
        String value = section.get(id);
        if (value != null) {
            try {
                return new URL(value);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return null;
    }

    public static void setOriginatingURL(String id, URL url) {
        IDialogSettings section = UpdateUI.getOriginatingURLSection();
        section.put(id, url.toString());
    }

    private static IDialogSettings getOriginatingURLSection() {
        IDialogSettings settings = UpdateUI.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection("originatingURLs");
        if (section == null) {
            section = settings.addNewSection("originatingURLs");
        }
        return section;
    }

    public static void requestRestart(boolean restartIsReallyNeeded) {
        boolean restart = RestartDialog.openQuestion(UpdateUI.getActiveWorkbenchShell(), restartIsReallyNeeded);
        if (restart) {
            PlatformUI.getWorkbench().restart();
        }
    }

    public static void showURL(String url) {
        UpdateUI.showURL(url, false);
    }

    public static void showURL(String url, boolean encodeHostAndPort) {
        if (encodeHostAndPort) {
            url = UpdateUI.encodeHostAndPort(url);
        }
        IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
        try {
            IWebBrowser browser = support.getExternalBrowser();
            browser.openURL(new URL(url));
        }
        catch (MalformedURLException e) {
            UpdateUI.logException(e);
        }
        catch (PartInitException e) {
            UpdateUI.logException(e);
        }
    }

    private static String encodeHostAndPort(String urlName) {
        String callbackURL = UpdateUI.getCallbackURLAsString();
        if (callbackURL == null) {
            return urlName;
        }
        String callbackParameter = "updateURL=" + callbackURL;
        if (urlName.indexOf(63) != -1) {
            return String.valueOf(urlName) + "&" + callbackParameter;
        }
        return String.valueOf(urlName) + "?" + callbackParameter;
    }

    private static String getCallbackURLAsString() {
        String host = UpdateUI.getDefault().getAppServerHost();
        int port = UpdateUI.getDefault().getAppServerPort();
        if (host == null || port == 0) {
            return null;
        }
        String value = "http://" + host + ":" + port + "/" + WEB_APP_ID + "/install";
        try {
            value = URLCoder.encode(value);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        return value;
    }

    public static boolean getRemindOnCancel() {
        return remindOnCancel;
    }

    public static void setRemindOnCancel(boolean remind) {
        remindOnCancel = remind;
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    protected void initializeDefaultPluginPreferences() {
        Preferences store = this.getPluginPreferences();
        store.setDefault(P_DISCOVERY_SITES_ENABLED, true);
    }
}

