/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.preferences;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.ui.UpdateUIMessages;

public class UpdateSettingsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Text mappingsFile;

    public UpdateSettingsPreferencePage() {
        this.setDescription(UpdateUIMessages.UpdateSettingsPreferencePage_description);
    }

    public void init(IWorkbench workbench) {
    }

    public Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        Label label = new Label(container, 0);
        label.setText(UpdateUIMessages.UpdateSettingsPreferencePage_label);
        this.mappingsFile = new Text(container, 2052);
        this.initialize();
        this.mappingsFile.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                UpdateSettingsPreferencePage.this.textChanged();
            }
        });
        GridData gd = new GridData(768);
        this.mappingsFile.setLayoutData((Object)gd);
        return container;
    }

    private void initialize() {
        Preferences pref = UpdateCore.getPlugin().getPluginPreferences();
        String text = pref.getString("updatePolicyURL");
        this.mappingsFile.setText(text);
        this.textChanged();
    }

    private void textChanged() {
        String text = this.mappingsFile.getText();
        if (text.length() > 0) {
            try {
                new URL(text);
            }
            catch (MalformedURLException malformedURLException) {
                this.setValid(false);
                this.setErrorMessage(UpdateUIMessages.UpdateSettingsPreferencePage_invalid);
                return;
            }
        }
        this.setValid(true);
        this.setErrorMessage(null);
    }

    public boolean performOk() {
        Preferences pref = UpdateCore.getPlugin().getPluginPreferences();
        String text = this.mappingsFile.getText();
        if (text.length() > 0) {
            pref.setValue("updatePolicyURL", text);
        } else {
            pref.setToDefault("updatePolicyURL");
        }
        UpdateCore.getPlugin().savePluginPreferences();
        return true;
    }

    protected void performDefaults() {
        this.mappingsFile.setText("");
        super.performDefaults();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Dialog.applyDialogFont(this.getControl());
    }
}

