/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.properties;

import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IURLEntry;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.UpdateUIMessages;
import org.eclipse.update.internal.ui.model.IFeatureAdapter;
import org.eclipse.update.internal.ui.parts.SWTUtil;

public class FeatureCopyrightPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    public FeatureCopyrightPropertyPage() {
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        try {
            String annotation;
            IFeatureAdapter adapter = (IFeatureAdapter)((Object)this.getElement());
            IFeature feature = adapter.getFeature(null);
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout());
            Label label = new Label(composite, 64);
            GridData gd = new GridData(770);
            gd.widthHint = this.computeWidthLimit(label, 80);
            label.setLayoutData((Object)gd);
            IURLEntry copyright = feature.getCopyright();
            String string = annotation = copyright != null ? copyright.getAnnotation() : null;
            if (annotation != null && annotation.length() > 0) {
                String filename;
                label.setText(annotation);
                final URL url = copyright.getURL();
                String string2 = filename = url != null ? url.getFile() : null;
                if (filename != null && (filename.endsWith(".htm") || filename.endsWith(".html"))) {
                    Button button = new Button(composite, 8);
                    button.setText(UpdateUIMessages.FeatureCopyrightPropertyPage_showInBrowser);
                    button.setLayoutData((Object)new GridData(128));
                    SWTUtil.setButtonDimensionHint(button);
                    button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            UpdateUI.showURL(url.toExternalForm());
                        }
                    });
                }
            } else {
                label.setText(UpdateUIMessages.FeatureCopyrightPropertyPage_noCopyright);
            }
            Dialog.applyDialogFont((Control)parent);
        }
        catch (CoreException coreException) {}
        return null;
    }

    private int computeWidthLimit(Label label, int nchars) {
        GC gc = new GC((Drawable)label);
        gc.setFont(label.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        return Dialog.convertWidthInCharsToPixels(fontMetrics, nchars);
    }
}

