/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.common.actions;

import com.savvytest.eclipse.common.Savvytest;
import java.util.Iterator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;

public class CollapseAction
extends Action {
    public static final String ID = "collapse";
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.common.actions.CollapseAction.";
    private TreeViewer viewer;
    private boolean collapseAll;

    private static String getClassString(String key) {
        return Savvytest.getString(TRANSLATION_PREFIX + key, new Object[0]);
    }

    public CollapseAction(TreeViewer viewer, boolean collapseAll) {
        if (viewer == null) {
            throw new IllegalArgumentException("Viewer must not be null.");
        }
        this.viewer = viewer;
        this.collapseAll = collapseAll;
        this.setId(ID);
        this.setText(CollapseAction.getClassString("name"));
        ImageDescriptor collapseImg = ImageDescriptor.createFromFile(this.getClass(), "/icons/actions/collapseall.gif");
        this.setImageDescriptor(collapseImg);
    }

    @Override
    public void run() {
        if (this.viewer.getControl().isDisposed()) {
            return;
        }
        IStructuredSelection selection = this.collapseAll ? new StructuredSelection(this.viewer.getInput()) : (IStructuredSelection)this.viewer.getSelection();
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            this.viewer.collapseToLevel(obj, -1);
        }
    }
}

