/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.common.actions;

import com.savvytest.eclipse.common.Savvytest;
import java.util.Iterator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;

public class ExpandAction
extends Action {
    public static final String ID = "expand";
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.common.actions.ExpandAction.";
    private TreeViewer viewer;
    private boolean expandAll;

    private static String getClassString(String key) {
        return Savvytest.getString(TRANSLATION_PREFIX + key, new Object[0]);
    }

    public ExpandAction(TreeViewer viewer, boolean expandAll) {
        if (viewer == null) {
            throw new IllegalArgumentException("Viewer must not be null.");
        }
        this.viewer = viewer;
        this.expandAll = expandAll;
        this.setId(ID);
        this.setText(ExpandAction.getClassString("name"));
        ImageDescriptor expandImg = ImageDescriptor.createFromFile(this.getClass(), "/icons/actions/expandall.gif");
        this.setImageDescriptor(expandImg);
    }

    @Override
    public void run() {
        if (this.viewer.getControl().isDisposed()) {
            return;
        }
        IStructuredSelection selection = this.expandAll ? new StructuredSelection(this.viewer.getInput()) : (IStructuredSelection)this.viewer.getSelection();
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            this.viewer.expandToLevel(obj, -1);
        }
    }
}

