/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.common.util.editing;

import com.savvytest.eclipse.common.actions.CollapseAction;
import com.savvytest.eclipse.common.actions.ExpandAction;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;

public class ElementTreeSelectionDialogWithContextMenu
extends ElementTreeSelectionDialog
implements ISelectionProvider {
    private final Set<ISelectionChangedListener> listeners = new HashSet<ISelectionChangedListener>();
    private IElementComparer comparer;
    private MenuManager manager;
    private Font font;
    private Color foreground;
    private int autoExpand = 0;

    public ElementTreeSelectionDialogWithContextMenu(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
        super(parent, labelProvider, contentProvider);
    }

    protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
        TreeViewer viewer = new TreeViewer(parent, style);
        viewer.setAutoExpandLevel(this.autoExpand);
        return viewer;
    }

    @Override
    protected TreeViewer createTreeViewer(Composite parent) {
        TreeViewer viewer = super.createTreeViewer(parent);
        viewer.setComparer(this.getComparer());
        if (this.manager != null) {
            this.setContextManager(viewer);
        }
        for (ISelectionChangedListener listener : this.listeners) {
            viewer.addSelectionChangedListener(listener);
        }
        return viewer;
    }

    @Override
    public void create() {
        super.create();
        TreeViewer viewer = this.getTreeViewer();
        if (this.font != null) {
            viewer.getTree().setFont(this.font);
            viewer.getTree().getParent().setFont(this.font);
        }
        if (this.foreground != null) {
            viewer.getTree().setForeground(this.foreground);
        }
    }

    private void setContextManager(TreeViewer viewer) {
        Menu menu = null;
        if (this.manager == null) {
            this.manager = new MenuManager("#PopUp");
        }
        this.manager.add(new CollapseAction(viewer, false));
        this.manager.add(new ExpandAction(viewer, false));
        menu = this.manager.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
    }

    public void setContextManager(MenuManager manager) {
        this.manager = manager;
        TreeViewer viewer = this.getTreeViewer();
        if (viewer != null) {
            this.setContextManager(viewer);
        }
    }

    public MenuManager getContextManager() {
        return this.manager;
    }

    @Override
    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
        TreeViewer viewer = this.getTreeViewer();
        if (viewer != null) {
            viewer.addSelectionChangedListener(listener);
        }
    }

    @Override
    public ISelection getSelection() {
        TreeViewer viewer = this.getTreeViewer();
        if (viewer != null) {
            return viewer.getSelection();
        }
        return StructuredSelection.EMPTY;
    }

    @Override
    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
        TreeViewer viewer = this.getTreeViewer();
        if (viewer != null) {
            viewer.removeSelectionChangedListener(listener);
        }
    }

    @Override
    public void setSelection(ISelection selection) {
        TreeViewer viewer = this.getTreeViewer();
        if (viewer != null) {
            viewer.setSelection(selection);
        }
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setForeground(Color foreground) {
        this.foreground = foreground;
    }

    public int getAutoExpandLevel() {
        return this.autoExpand;
    }

    public void setAutoExpandLevel(int level) {
        this.autoExpand = level;
        if (this.getTreeViewer() != null) {
            this.getTreeViewer().setAutoExpandLevel(level);
        }
    }

    public IElementComparer getComparer() {
        return this.comparer;
    }

    public void setComparer(IElementComparer comparer) {
        this.comparer = comparer;
        if (this.getTreeViewer() != null) {
            this.getTreeViewer().setComparer(comparer);
        }
    }
}

