/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.core.model.xml.data.provider;

import com.savvytest.eclipse.core.model.xml.data.Boolean;
import com.savvytest.eclipse.core.model.xml.data.DataPackage;
import com.savvytest.eclipse.core.model.xml.data.Number;
import com.savvytest.eclipse.core.model.xml.data.String;
import com.savvytest.eclipse.core.model.xml.data.Struct;
import com.savvytest.eclipse.core.model.xml.data.impl.UsageDataVisitor;
import com.savvytest.eclipse.core.model.xml.listructure.BaseType;
import com.savvytest.eclipse.core.model.xml.listructure.UsageType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.EnumSet;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.FeatureMapEntryWrapperItemProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IUpdateableItemText;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;

public class CustomFeatureMapEntryWrapperItemProvider
extends FeatureMapEntryWrapperItemProvider
implements IUpdateableItemText {
    private EnumSet<UsageType> visit = EnumSet.allOf(UsageType.class);

    public CustomFeatureMapEntryWrapperItemProvider(FeatureMap.Entry entry, EObject owner, EAttribute attribute, int index, AdapterFactory adapterFactory, ResourceLocator resourceLocator) {
        super(entry, owner, attribute, index, adapterFactory, resourceLocator);
    }

    @Override
    public void setText(Object object, java.lang.String text) {
        IItemPropertySource adapter = (IItemPropertySource)this.adapterFactory.adapt(object, IItemPropertySource.class);
        Object editable = adapter.getEditableValue(object);
        IItemPropertyDescriptor propertyDescriptor = null;
        Object value = null;
        if (editable instanceof String) {
            propertyDescriptor = adapter.getPropertyDescriptor(object, DataPackage.Literals.STRING__VALUE.getName());
            value = text;
        } else if (editable instanceof Boolean) {
            propertyDescriptor = adapter.getPropertyDescriptor(object, DataPackage.Literals.BOOLEAN__VALUE.getName());
            if (text != null) {
                value = java.lang.Boolean.valueOf(text);
            }
        } else if (editable instanceof Number) {
            propertyDescriptor = adapter.getPropertyDescriptor(object, DataPackage.Literals.NUMBER__VALUE.getName());
            if (text != null) {
                java.lang.String pointText = text.replace(',', '.');
                try {
                    value = new BigDecimal(pointText);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else if (editable instanceof Struct) {
            this.handleStructText(text, editable);
        }
        if (propertyDescriptor != null) {
            propertyDescriptor.setPropertyValue(object, value);
        }
    }

    private void handleStructText(java.lang.String text, Object editable) {
        final EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor(editable);
        final CompoundCommand cc = new CompoundCommand();
        UsageDataVisitor visitor = new UsageDataVisitor(this.visit, text){
            private java.lang.String remainingText;
            {
                super($anonymous0);
                this.remainingText = string;
            }

            @Override
            public Object visit(String string) throws Exception {
                java.lang.String textSegment = this.getTextSegment(string.getBaseType());
                if (textSegment == null) {
                    return null;
                }
                cc.append(SetCommand.create(editingDomain, string, DataPackage.Literals.STRING__VALUE, textSegment));
                return null;
            }

            @Override
            public Object visit(Number number) throws Exception {
                java.lang.String textSegment = this.getTextSegment(number.getBaseType());
                if (textSegment == null) {
                    return null;
                }
                try {
                    BigDecimal bigDecimal = new BigDecimal(textSegment);
                    cc.append(SetCommand.create(editingDomain, number, DataPackage.Literals.NUMBER__VALUE, bigDecimal));
                }
                catch (NumberFormatException numberFormatException) {
                    cc.append(SetCommand.create(editingDomain, number, DataPackage.Literals.NUMBER__VALUE, null));
                }
                return null;
            }

            @Override
            public Object visit(Boolean bool) throws Exception {
                java.lang.String textSegment = this.getTextSegment(bool.getBaseType());
                if (textSegment == null) {
                    return null;
                }
                cc.append(SetCommand.create(editingDomain, bool, DataPackage.Literals.BOOLEAN__VALUE, java.lang.Boolean.valueOf(textSegment)));
                return null;
            }

            @Override
            public Object visit(FeatureMap.Entry entry) throws Exception {
                if (this.remainingText == null || this.remainingText.isEmpty()) {
                    return null;
                }
                return super.visit(entry);
            }

            private java.lang.String getTextSegment(BaseType bt) {
                java.lang.String segment;
                if (bt == null) {
                    return null;
                }
                BigInteger biLength = bt.getLength();
                if (biLength == null) {
                    return null;
                }
                int length = biLength.intValue();
                if (length >= this.remainingText.length()) {
                    segment = this.remainingText;
                    this.remainingText = null;
                } else {
                    segment = this.remainingText.substring(0, length);
                    this.remainingText = this.remainingText.substring(length);
                }
                return segment;
            }
        };
        try {
            visitor.visit((Struct)editable);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!cc.isEmpty()) {
            editingDomain.getCommandStack().execute(cc);
        }
    }

    @Override
    public java.lang.String getUpdateableText(Object object) {
        IItemPropertySource adapter = (IItemPropertySource)this.adapterFactory.adapt(object, IItemPropertySource.class);
        Object editable = adapter.getEditableValue(object);
        java.lang.String updateableText = null;
        boolean isUpdateable = false;
        if (editable instanceof String) {
            updateableText = ((String)editable).getEffectiveValue();
            isUpdateable = true;
        } else if (editable instanceof Number) {
            BigDecimal value = ((Number)editable).getEffectiveValue();
            if (value != null) {
                updateableText = value.toString();
            }
            isUpdateable = true;
        } else if (editable instanceof Boolean) {
            java.lang.Boolean value = ((Boolean)editable).getEffectiveValue();
            if (value != null) {
                updateableText = value.toString();
            }
            isUpdateable = true;
        } else if (editable instanceof Struct) {
            isUpdateable = true;
        }
        if (isUpdateable) {
            return updateableText != null ? updateableText : "";
        }
        return null;
    }

    @Override
    protected IWrapperItemProvider createWrapper(Object value, Object owner, AdapterFactory adapterFactory) {
        if (value instanceof CustomFeatureMapEntryWrapperItemProvider) {
            return (IWrapperItemProvider)value;
        }
        return super.createWrapper(value, owner, adapterFactory);
    }

    protected void setVisit(EnumSet<UsageType> visit) {
        if (visit == null) {
            throw new IllegalArgumentException("Visit must not be null.");
        }
        this.visit = visit;
    }
}

