/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.core.model.xml.stub.util;

import com.savvytest.eclipse.core.model.xml.data.Argument;
import com.savvytest.eclipse.core.model.xml.data.Array;
import com.savvytest.eclipse.core.model.xml.data.Atomic;
import com.savvytest.eclipse.core.model.xml.data.Boolean;
import com.savvytest.eclipse.core.model.xml.data.Data;
import com.savvytest.eclipse.core.model.xml.data.DataFactory;
import com.savvytest.eclipse.core.model.xml.data.DataVisitor;
import com.savvytest.eclipse.core.model.xml.data.Number;
import com.savvytest.eclipse.core.model.xml.data.PersistentData;
import com.savvytest.eclipse.core.model.xml.data.String;
import com.savvytest.eclipse.core.model.xml.data.Struct;
import com.savvytest.eclipse.core.model.xml.listructure.BaseType;
import com.savvytest.eclipse.core.model.xml.properties.Properties;
import com.savvytest.eclipse.core.model.xml.properties.PropertiesFactory;
import com.savvytest.eclipse.core.model.xml.properties.util.PropertiesUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.util.FeatureMap;

public class BuildStubDataVisitor
implements DataVisitor {
    private java.lang.String currentPrefix = "";
    private final Argument dataArgument;
    private List<PersistentData> stubData = new ArrayList<PersistentData>();
    private boolean doSetValues = false;
    private int currentArrayIndex = -1;

    public BuildStubDataVisitor(Argument arg, java.lang.String prefix) {
        this(arg);
        this.currentPrefix = prefix;
    }

    public BuildStubDataVisitor(Argument arg, java.lang.String prefix, boolean doSetValues) {
        this(arg);
        this.currentPrefix = prefix;
        this.doSetValues = doSetValues;
    }

    public BuildStubDataVisitor(Argument arg) {
        this.dataArgument = arg;
    }

    public List<PersistentData> getStubData() throws Exception {
        this.stubData = new ArrayList<PersistentData>();
        for (FeatureMap.Entry entry : this.dataArgument.getParameters().getParameters()) {
            Data data = (Data)entry.getValue();
            data.accept(this);
        }
        return this.stubData;
    }

    @Override
    public Object visit(Struct struct) throws Exception {
        BaseType baseType = struct.getBaseType();
        java.lang.String suffix = this.currentArrayIndex > -1 ? "[" + this.currentArrayIndex + "]" : "";
        int arrayIndex = this.currentArrayIndex;
        this.currentArrayIndex = -1;
        for (FeatureMap.Entry entry : struct.getElements()) {
            java.lang.String structPrefix = this.currentPrefix;
            this.currentPrefix = this.currentPrefix.length() > 0 ? java.lang.String.valueOf(this.currentPrefix) + "." + baseType.getName() + suffix : java.lang.String.valueOf(baseType.getName()) + suffix;
            Data data = (Data)entry.getValue();
            data.accept(this);
            this.currentPrefix = structPrefix;
        }
        this.currentArrayIndex = arrayIndex;
        return null;
    }

    @Override
    public Object visit(Array array) throws Exception {
        int index = 0;
        for (FeatureMap.Entry entry : array.getElements()) {
            int arrayIndex = this.currentArrayIndex;
            java.lang.String arrayPrefix = this.currentPrefix;
            this.currentArrayIndex = index++;
            Data data = (Data)entry.getValue();
            data.accept(this);
            this.currentPrefix = arrayPrefix;
            this.currentArrayIndex = arrayIndex;
        }
        this.currentArrayIndex = -1;
        return null;
    }

    @Override
    public Object visit(String string) throws Exception {
        return this.visitAtomic(string, PropertiesUtils.PropertyEnum.VALUE_STRING);
    }

    @Override
    public Object visit(Number number) throws Exception {
        return this.visitAtomic(number, PropertiesUtils.PropertyEnum.VALUE_NUMBER);
    }

    @Override
    public Object visit(Boolean bool) throws Exception {
        return this.visitAtomic(bool, PropertiesUtils.PropertyEnum.VALUE_BOOLEAN);
    }

    private Object visitAtomic(Atomic atomic, PropertiesUtils.PropertyEnum type) {
        BaseType baseType = atomic.getBaseType();
        PersistentData data = DataFactory.eINSTANCE.createPersistentData();
        data.setBaseType(baseType);
        atomic.setPersistentData(data);
        java.lang.String suffix = this.currentArrayIndex > -1 ? "[" + this.currentArrayIndex + "]" : "";
        java.lang.String index = java.lang.String.valueOf(this.currentPrefix) + "." + baseType.getName() + suffix;
        java.lang.String value = null;
        if (this.doSetValues && atomic.getValue() != null) {
            value = atomic.getValue().toString();
        }
        Properties properties = PropertiesFactory.eINSTANCE.createProperties();
        properties.getProperties().add(PropertiesUtils.createProperty(type, value));
        properties.getProperties().add(PropertiesUtils.createProperty(PropertiesUtils.PropertyEnum.INDEX, index));
        data.setProperties(properties);
        data.setId(index);
        this.stubData.add(data);
        return null;
    }
}

