/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.provisional.swt;

import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.jface.internal.databinding.provisional.swt.SWTUtil;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;

public abstract class CompositeUpdater {
    private PrivateInterface privateInterface = new PrivateInterface();
    private Composite theComposite;
    private IObservableList model;

    public CompositeUpdater(Composite toUpdate, IObservableList model) {
        this.theComposite = toUpdate;
        this.model = model;
        model.addListChangeListener(this.privateInterface);
        this.theComposite.addDisposeListener((DisposeListener)this.privateInterface);
    }

    public void dispose() {
        this.theComposite.removeDisposeListener((DisposeListener)this.privateInterface);
        this.model.removeListChangeListener(this.privateInterface);
    }

    protected abstract Widget createWidget(int var1);

    protected abstract void updateWidget(Widget var1, Object var2);

    private class PrivateInterface
    implements DisposeListener,
    IListChangeListener {
        private PrivateInterface() {
        }

        public void widgetDisposed(DisposeEvent e) {
            CompositeUpdater.this.dispose();
        }

        public void handleListChange(ListChangeEvent event) {
            ListDiffEntry[] diffs = event.diff.getDifferences();
            int i = 0;
            while (i < diffs.length) {
                ListDiffEntry listDiffEntry = diffs[i];
                if (listDiffEntry.isAddition()) {
                    Widget newChild = CompositeUpdater.this.createWidget(listDiffEntry.getPosition());
                    UpdateRunnable updateRunnable = new UpdateRunnable(newChild, listDiffEntry.getElement());
                    newChild.setData((Object)updateRunnable);
                    updateRunnable.updateIfNecessary();
                } else {
                    CompositeUpdater.this.theComposite.getChildren()[listDiffEntry.getPosition()].dispose();
                }
                ++i;
            }
            CompositeUpdater.this.theComposite.layout();
        }
    }

    private class UpdateRunnable
    implements Runnable,
    IChangeListener {
        private Widget widget;
        Object element;
        private boolean dirty = true;
        private IObservable[] dependencies = new IObservable[0];

        UpdateRunnable(Widget widget, Object element) {
            this.widget = widget;
            this.element = element;
        }

        public void run() {
            if (CompositeUpdater.this.theComposite != null && !CompositeUpdater.this.theComposite.isDisposed() && this.widget != null && !this.widget.isDisposed()) {
                this.updateIfNecessary();
            }
        }

        private void updateIfNecessary() {
            if (this.dirty) {
                this.dependencies = ObservableTracker.runAndMonitor(new Runnable(this){
                    final /* synthetic */ UpdateRunnable this$1;
                    {
                        this.this$1 = updateRunnable;
                    }

                    public void run() {
                        UpdateRunnable.access$2(this.this$1).updateWidget(UpdateRunnable.access$0(this.this$1), this.this$1.element);
                    }
                }, this, null);
                this.dirty = false;
            }
        }

        public void handleChange(ChangeEvent event) {
            this.makeDirty();
        }

        protected final void makeDirty() {
            if (!this.dirty) {
                this.dirty = true;
                this.stopListening();
                if (!CompositeUpdater.this.theComposite.isDisposed()) {
                    SWTUtil.runOnce(CompositeUpdater.this.theComposite.getDisplay(), this);
                }
            }
        }

        private void stopListening() {
            int i = 0;
            while (i < this.dependencies.length) {
                IObservable observable = this.dependencies[i];
                observable.removeChangeListener(this);
                ++i;
            }
        }

        static /* synthetic */ Widget access$0(UpdateRunnable updateRunnable) {
            return updateRunnable.widget;
        }

        static /* synthetic */ CompositeUpdater access$2(UpdateRunnable updateRunnable) {
            return updateRunnable.CompositeUpdater.this;
        }
    }
}

