/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.ide.IDEInternalWorkbenchImages;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.actions.BuildUtilities;

public class GlobalBuildAction
extends Action
implements ActionFactory.IWorkbenchAction {
    private int buildType;
    private IWorkbenchWindow workbenchWindow;

    public GlobalBuildAction(IWorkbench workbench, Shell shell, int type) {
        this(workbench.getActiveWorkbenchWindow(), type);
        if (shell == null) {
            throw new IllegalArgumentException();
        }
    }

    public GlobalBuildAction(IWorkbenchWindow window, int type) {
        if (window == null) {
            throw new IllegalArgumentException();
        }
        this.workbenchWindow = window;
        this.setBuildType(type);
    }

    private void setBuildType(int type) {
        switch (type) {
            case 9: 
            case 10: {
                this.setText(IDEWorkbenchMessages.GlobalBuildAction_text);
                this.setToolTipText(IDEWorkbenchMessages.GlobalBuildAction_toolTip);
                this.setId("build");
                this.workbenchWindow.getWorkbench().getHelpSystem().setHelp(this, "org.eclipse.ui.ide.global_incremental_build_action_context");
                this.setImageDescriptor(IDEInternalWorkbenchImages.getImageDescriptor("IMG_ETOOL_BUILD_EXEC"));
                this.setDisabledImageDescriptor(IDEInternalWorkbenchImages.getImageDescriptor("IMG_ETOOL_BUILD_EXEC_DISABLED"));
                this.setActionDefinitionId("org.eclipse.ui.project.buildAll");
                break;
            }
            case 6: {
                this.setText(IDEWorkbenchMessages.GlobalBuildAction_rebuildText);
                this.setToolTipText(IDEWorkbenchMessages.GlobalBuildAction_rebuildToolTip);
                this.setId("rebuildAll");
                this.workbenchWindow.getWorkbench().getHelpSystem().setHelp(this, "org.eclipse.ui.ide.global_full_build_action_context");
                this.setActionDefinitionId("org.eclipse.ui.project.rebuildAll");
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid build type");
            }
        }
        this.buildType = type;
    }

    private Shell getShell() {
        return this.workbenchWindow.getShell();
    }

    private String getOperationMessage() {
        if (this.buildType == 10) {
            return IDEWorkbenchMessages.GlobalBuildAction_buildOperationTitle;
        }
        return IDEWorkbenchMessages.GlobalBuildAction_rebuildAllOperationTitle;
    }

    public void doBuild() {
        this.doBuildOperation();
    }

    void doBuildOperation() {
        Job buildJob = new Job(IDEWorkbenchMessages.GlobalBuildAction_jobTitle){

            protected IStatus run(IProgressMonitor monitor) {
                MultiStatus status = new MultiStatus("org.eclipse.ui", 0, IDEWorkbenchMessages.GlobalBuildAction_buildProblems, null);
                monitor.beginTask(GlobalBuildAction.this.getOperationMessage(), 100);
                try {
                    try {
                        ResourcesPlugin.getWorkspace().build(GlobalBuildAction.this.buildType, new SubProgressMonitor(monitor, 100));
                    }
                    catch (CoreException e) {
                        status.add(e.getStatus());
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
                return status;
            }

            public boolean belongsTo(Object family) {
                return ResourcesPlugin.FAMILY_MANUAL_BUILD == family;
            }
        };
        buildJob.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        buildJob.setUser(true);
        buildJob.schedule();
    }

    IProject[] getWorkspaceProjects() {
        return ResourcesPlugin.getWorkspace().getRoot().getProjects();
    }

    public void run() {
        if (this.workbenchWindow == null) {
            return;
        }
        IProject[] roots = this.getWorkspaceProjects();
        if (roots.length < 1) {
            return;
        }
        if (!this.verifyBuildersAvailable(roots)) {
            return;
        }
        if (!this.verifyNoManualRunning()) {
            return;
        }
        BuildUtilities.saveEditors(null);
        this.doBuildOperation();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean verifyBuildersAvailable(IProject[] roots) {
        try {
            int i = 0;
            while (true) {
                if (i >= roots.length) {
                    return false;
                }
                if (roots[i].isAccessible() && roots[i].getDescription().getBuildSpec().length > 0) {
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            IDEWorkbenchPlugin.log(this.getClass(), "verifyBuildersAvailable", e);
            ErrorDialog.openError(this.getShell(), IDEWorkbenchMessages.GlobalBuildAction_buildProblems, NLS.bind(IDEWorkbenchMessages.GlobalBuildAction_internalError, e.getMessage()), e.getStatus());
            return false;
        }
    }

    public void dispose() {
        if (this.workbenchWindow == null) {
            return;
        }
        this.workbenchWindow = null;
    }

    private boolean verifyNoManualRunning() {
        Job[] buildJobs = Platform.getJobManager().find(ResourcesPlugin.FAMILY_MANUAL_BUILD);
        if (buildJobs.length == 0) {
            return true;
        }
        boolean cancel = MessageDialog.openQuestion(this.workbenchWindow.getShell(), IDEWorkbenchMessages.GlobalBuildAction_BuildRunningTitle, IDEWorkbenchMessages.GlobalBuildAction_BuildRunningMessage);
        if (cancel) {
            int i = 0;
            while (i < buildJobs.length) {
                Job job = buildJobs[i];
                job.cancel();
                ++i;
            }
        }
        return false;
    }
}

