/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.ide.dialogs;

import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.List;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.WorkbenchEncoding;
import org.eclipse.ui.ide.IDEEncoding;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public abstract class AbstractEncodingFieldEditor
extends FieldEditor {
    private Composite container;
    private Button defaultEncodingButton;
    private String defaultEnc;
    private Button otherEncodingButton;
    private Combo encodingCombo;
    private boolean isValid = true;
    private String oldSelectedEncoding;
    private String groupTitle = IDEWorkbenchMessages.WorkbenchPreference_encoding;

    protected AbstractEncodingFieldEditor() {
    }

    protected AbstractEncodingFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
    }

    protected AbstractEncodingFieldEditor(String name, String labelText, String groupTitle, Composite parent) {
        this.init(name, labelText);
        this.groupTitle = groupTitle;
        this.createControl(parent);
    }

    protected void adjustForNumColumns(int numColumns) {
        ((GridData)this.getContainer().getLayoutData()).horizontalSpan = numColumns;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.container = this.createEncodingGroup(parent, numColumns);
    }

    protected void doLoad() {
        if (this.encodingCombo != null) {
            List encodings = IDEEncoding.getIDEEncodings();
            String resourcePreference = this.getStoredValue();
            this.populateEncodingsCombo(encodings, resourcePreference);
            this.updateEncodingState(resourcePreference == null);
        }
    }

    protected abstract String getStoredValue();

    protected void doLoadDefault() {
        this.updateEncodingState(true);
    }

    public int getNumberOfControls() {
        return 1;
    }

    public boolean isValid() {
        return this.isValid;
    }

    protected void refreshValidState() {
        this.updateValidState();
    }

    public void setPreferenceStore(IPreferenceStore store) {
        super.setPreferenceStore(store);
        this.defaultEnc = store.getDefaultString(this.getPreferenceName());
        this.updateDefaultEncoding();
    }

    private void updateDefaultEncoding() {
        this.defaultEncodingButton.setText(this.defaultButtonText());
    }

    private Composite getContainer() {
        return this.container;
    }

    protected Composite createEncodingGroup(Composite parent, int numColumns) {
        Composite topControl;
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        if (this.groupTitle == null) {
            topControl = new Composite(parent, 0);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
        } else {
            Group top = new Group(parent, 0);
            top.setText(this.groupTitle);
            topControl = top;
        }
        GridData data = new GridData(768);
        topControl.setLayoutData((Object)data);
        topControl.setLayout((Layout)layout);
        SelectionAdapter buttonListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractEncodingFieldEditor.this.updateEncodingState(AbstractEncodingFieldEditor.this.defaultEncodingButton.getSelection());
                AbstractEncodingFieldEditor.this.updateValidState();
            }
        };
        this.defaultEncodingButton = new Button(topControl, 16);
        this.defaultEnc = this.findDefaultEncoding();
        this.defaultEncodingButton.setText(this.defaultButtonText());
        data = new GridData();
        data.horizontalSpan = 2;
        this.defaultEncodingButton.setLayoutData((Object)data);
        this.defaultEncodingButton.addSelectionListener((SelectionListener)buttonListener);
        this.otherEncodingButton = new Button(topControl, 16);
        this.otherEncodingButton.setText(IDEWorkbenchMessages.WorkbenchPreference_otherEncoding);
        this.otherEncodingButton.addSelectionListener((SelectionListener)buttonListener);
        this.encodingCombo = new Combo(topControl, 0);
        data = new GridData();
        this.encodingCombo.setLayoutData((Object)data);
        this.encodingCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractEncodingFieldEditor.this.updateValidState();
            }
        });
        this.encodingCombo.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                AbstractEncodingFieldEditor.this.updateValidState();
            }
        });
        return topControl;
    }

    public void setEnabled(boolean enabled, Composite parent) {
        if (this.container != null) {
            this.container.setEnabled(enabled);
        }
        if (this.defaultEncodingButton != null) {
            this.defaultEncodingButton.setEnabled(enabled);
        }
        if (this.otherEncodingButton != null) {
            this.otherEncodingButton.setEnabled(enabled);
        }
        if (this.encodingCombo != null) {
            this.encodingCombo.setEnabled(enabled);
        }
    }

    protected String findDefaultEncoding() {
        return WorkbenchEncoding.getWorkbenchDefaultEncoding();
    }

    protected String defaultButtonText() {
        return NLS.bind(IDEWorkbenchMessages.WorkbenchPreference_defaultEncoding, this.defaultEnc);
    }

    private void populateEncodingsCombo(List encodings, String selectedEncoding) {
        String[] encodingStrings = new String[encodings.size()];
        encodings.toArray(encodingStrings);
        this.encodingCombo.setItems(encodingStrings);
        if (selectedEncoding == null) {
            this.encodingCombo.setText(this.getDefaultEnc());
        } else {
            this.encodingCombo.setText(selectedEncoding);
        }
    }

    private void updateEncodingState(boolean useDefault) {
        this.defaultEncodingButton.setSelection(useDefault);
        this.otherEncodingButton.setSelection(!useDefault);
        if (useDefault) {
            this.encodingCombo.setText(this.getDefaultEnc());
        }
        this.encodingCombo.setEnabled(!useDefault);
        this.setPresentsDefaultValue(useDefault);
        this.updateValidState();
    }

    private void updateValidState() {
        boolean isValidNow = this.isEncodingValid();
        if (isValidNow != this.isValid) {
            this.isValid = isValidNow;
            if (this.isValid) {
                this.clearErrorMessage();
            } else {
                this.showErrorMessage(IDEWorkbenchMessages.WorkbenchPreference_unsupportedEncoding);
            }
            this.fireStateChanged("field_editor_is_valid", !this.isValid, this.isValid);
        }
        String newValue = this.getSelectedEncoding();
        if (this.isValid && !newValue.equals(this.oldSelectedEncoding)) {
            this.fireValueChanged("field_editor_value", this.oldSelectedEncoding, newValue);
            this.oldSelectedEncoding = newValue;
        }
    }

    protected String getSelectedEncoding() {
        if (this.defaultEncodingButton.getSelection()) {
            return this.defaultEnc;
        }
        return this.encodingCombo.getText();
    }

    private boolean isEncodingValid() {
        return this.defaultEncodingButton.getSelection() || this.isValidEncoding(this.encodingCombo.getText());
    }

    private boolean isValidEncoding(String enc) {
        try {
            return Charset.isSupported(enc);
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            return false;
        }
    }

    protected String getDefaultEnc() {
        return this.defaultEnc;
    }

    protected boolean hasSameEncoding(String encodingSetting) {
        String current = this.getStoredValue();
        if (encodingSetting == null) {
            return current == null || current.length() == 0;
        }
        return encodingSetting.equals(current);
    }

    boolean isDefaultSelected() {
        return this.defaultEncodingButton.getSelection();
    }

    public void setGroupTitle(String groupTitle) {
        this.groupTitle = groupTitle;
    }
}

