/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.ide.undo;

import java.net.URI;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ui.ide.undo.AbstractCopyOrMoveResourcesOperation;
import org.eclipse.ui.ide.undo.ResourceDescription;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.ide.undo.ProjectDescription;
import org.eclipse.ui.internal.ide.undo.UndoMessages;

public class CopyProjectOperation
extends AbstractCopyOrMoveResourcesOperation {
    private URI projectLocation;
    private IProject originalProject;
    private ProjectDescription originalProjectDescription;

    public CopyProjectOperation(IProject project, String name, URI location, String label) {
        super(new IResource[]{project}, new Path(name), label);
        Assert.isLegal(project != null);
        this.originalProject = project;
        this.projectLocation = location != null && URIUtil.toPath(location).equals(Platform.getLocation()) ? null : location;
    }

    private IProject getProposedProjectHandle() {
        if (this.destination.segmentCount() == 1) {
            return this.getWorkspace().getRoot().getProject(this.destination.lastSegment());
        }
        return null;
    }

    protected IStatus computeMoveOrCopyStatus() {
        IStatus status = Status.OK_STATUS;
        IProject project = this.getProposedProjectHandle();
        if (project == null) {
            return this.getErrorStatus(UndoMessages.AbstractResourcesOperation_NotEnoughInfo);
        }
        if (this.projectLocation != null) {
            status = this.getWorkspace().validateProjectLocationURI(project, this.projectLocation);
        }
        if (status.isOK()) {
            return super.computeMoveOrCopyStatus();
        }
        return status;
    }

    protected void doExecute(IProgressMonitor monitor, IAdaptable uiInfo) throws CoreException {
        IProject newProject = this.copyProject(this.originalProject, this.destination, this.projectLocation, monitor);
        this.setTargetResources(new IResource[]{newProject});
        this.setResourceDescriptions(new ResourceDescription[0]);
    }

    protected void doUndo(IProgressMonitor monitor, IAdaptable uiInfo) throws CoreException {
        WorkspaceUndoUtil.delete(this.resources, new SubProgressMonitor(monitor, 1), uiInfo, true);
        this.setTargetResources(new IResource[]{this.originalProject});
        this.setResourceDescriptions(new ResourceDescription[0]);
    }

    protected boolean isDestinationPathValid(IResource resource, int index) {
        return true;
    }

    protected String getProposedName(IResource resource, int index) {
        return this.destination.lastSegment();
    }

    protected boolean updateResourceChangeDescriptionFactory(IResourceChangeDescriptionFactory factory, int operation) {
        boolean update = false;
        if (operation == UNDO) {
            int i = 0;
            while (i < this.resources.length) {
                update = true;
                IResource resource = this.resources[i];
                factory.delete(resource);
                ++i;
            }
        } else {
            factory.copy(this.originalProject, this.getDestinationPath(this.originalProject, 0));
        }
        return update;
    }

    public IStatus computeUndoableStatus(IProgressMonitor monitor) {
        IStatus status = super.computeUndoableStatus(monitor);
        if (!status.isOK()) {
            return status;
        }
        if (this.originalProject == null || !this.originalProjectDescription.verifyExistence(true)) {
            this.markInvalid();
            return this.getErrorStatus(UndoMessages.CopyResourcesOperation_NotAllowedDueToDataLoss);
        }
        if (status.isOK()) {
            status = this.computeDeleteStatus();
        }
        return status;
    }

    IProject copyProject(IProject project, IPath destinationPath, URI locationURI, IProgressMonitor monitor) throws CoreException {
        monitor.setTaskName(UndoMessages.AbstractCopyOrMoveResourcesOperation_copyProjectProgress);
        boolean open = project.isOpen();
        if (!open) {
            project.open(null);
        }
        this.originalProjectDescription = new ProjectDescription(project);
        IProjectDescription description = project.getDescription();
        description.setName(destinationPath.lastSegment());
        description.setLocationURI(locationURI);
        project.copy(description, 33, monitor);
        if (!open) {
            project.close(null);
        }
        return (IProject)this.getWorkspace().getRoot().findMember(destinationPath);
    }
}

