/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.CreateMarkersOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.part.MarkerTransfer;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerSelectionProviderAction;
import org.eclipse.ui.views.markers.internal.Util;

public class ActionPasteMarker
extends MarkerSelectionProviderAction {
    private IWorkbenchPart part;
    private Clipboard clipboard;
    private String[] pastableTypes;
    private String markerName;

    public ActionPasteMarker(IWorkbenchPart part, ISelectionProvider provider, String markerName) {
        super(provider, MarkerMessages.pasteAction_title);
        this.part = part;
        this.pastableTypes = new String[0];
        this.markerName = markerName;
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_PASTE"));
        this.setEnabled(false);
    }

    void setClipboard(Clipboard clipboard) {
        this.clipboard = clipboard;
    }

    public void run() {
        MarkerTransfer transfer = MarkerTransfer.getInstance();
        IMarker[] markerData = (IMarker[])this.clipboard.getContents((Transfer)transfer);
        this.paste(markerData);
    }

    void paste(final IMarker[] markers) {
        if (markers == null) {
            return;
        }
        final ArrayList newMarkerTypes = new ArrayList();
        final ArrayList newMarkerAttributes = new ArrayList();
        final ArrayList newMarkerResources = new ArrayList();
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    int i = 0;
                    while (i < markers.length) {
                        newMarkerTypes.add(markers[i].getType());
                        newMarkerResources.add(markers[i].getResource());
                        newMarkerAttributes.add(markers[i].getAttributes());
                        ++i;
                    }
                }
            }, null);
        }
        catch (CoreException e) {
            ErrorDialog.openError(this.part.getSite().getShell(), MarkerMessages.PasteMarker_errorTitle, null, e.getStatus());
            return;
        }
        String[] types = newMarkerTypes.toArray(new String[newMarkerTypes.size()]);
        Map[] attrs = newMarkerAttributes.toArray(new Map[newMarkerAttributes.size()]);
        IResource[] resources = newMarkerResources.toArray(new IResource[newMarkerResources.size()]);
        String operationTitle = NLS.bind(MarkerMessages.qualifiedMarkerCommand_title, MarkerMessages.pasteAction_title, this.markerName);
        final CreateMarkersOperation op = new CreateMarkersOperation(types, attrs, resources, operationTitle);
        this.execute(op, MarkerMessages.PasteMarker_errorTitle, null, WorkspaceUndoUtil.getUIInfoAdapter(this.part.getSite().getShell()));
        if (this.getSelectionProvider() != null && op.getMarkers() != null) {
            this.part.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    ActionPasteMarker.this.getSelectionProvider().setSelection(new StructuredSelection(op.getMarkers()));
                }
            });
        }
    }

    void updateEnablement() {
        this.setEnabled(false);
        if (this.clipboard == null) {
            return;
        }
        MarkerTransfer transfer = MarkerTransfer.getInstance();
        IMarker[] markerData = (IMarker[])this.clipboard.getContents((Transfer)transfer);
        if (markerData == null || markerData.length < 1 || this.pastableTypes == null) {
            return;
        }
        int i = 0;
        while (i < markerData.length) {
            try {
                IMarker marker = markerData[i];
                if (!marker.exists()) break;
                boolean pastable = false;
                int j = 0;
                while (j < this.pastableTypes.length) {
                    if (marker.isSubtypeOf(this.pastableTypes[j])) {
                        pastable = true;
                        break;
                    }
                    ++j;
                }
                if (!pastable) {
                    return;
                }
                if (!Util.isEditable(marker)) {
                    return;
                }
            }
            catch (CoreException coreException) {
                return;
            }
            ++i;
        }
        this.setEnabled(true);
    }

    void setPastableTypes(String[] strings) {
        this.pastableTypes = strings;
    }
}

