/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.core;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.FeatureReference;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureContentConsumer;
import org.eclipse.update.core.IFeatureContentProvider;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IImport;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.IInstallHandlerEntry;
import org.eclipse.update.core.INonPluginEntry;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.IURLEntry;
import org.eclipse.update.core.IVerificationListener;
import org.eclipse.update.core.IVerificationResult;
import org.eclipse.update.core.IVerifier;
import org.eclipse.update.core.IncludedFeatureReference;
import org.eclipse.update.core.InstallMonitor;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.core.model.FeatureModel;
import org.eclipse.update.core.model.FeatureReferenceModel;
import org.eclipse.update.core.model.ImportModel;
import org.eclipse.update.core.model.InstallAbortedException;
import org.eclipse.update.core.model.NonPluginEntryModel;
import org.eclipse.update.core.model.PluginEntryModel;
import org.eclipse.update.core.model.URLEntryModel;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.TargetFeature;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;
import org.eclipse.update.internal.core.UpdateSiteIncludedFeatureReference;

public class Feature
extends FeatureModel
implements IFeature {
    public static final String FEATURE_FILE = "feature";
    public static final String FEATURE_XML = "feature.xml";
    private ISite site;
    private IFeatureContentProvider featureContentProvider;
    private List includedFeatureReferences;
    private VersionedIdentifier versionId;
    private InstallAbortedException abortedException = null;

    public boolean equals(Object object) {
        if (!(object instanceof IFeature)) {
            return false;
        }
        IFeature f = (IFeature)object;
        return this.getVersionedIdentifier().equals(f.getVersionedIdentifier());
    }

    public VersionedIdentifier getVersionedIdentifier() {
        if (this.versionId != null) {
            return this.versionId;
        }
        String id = this.getFeatureIdentifier();
        String ver = this.getFeatureVersion();
        if (id != null && ver != null) {
            try {
                this.versionId = new VersionedIdentifier(id, ver);
                return this.versionId;
            }
            catch (Exception exception) {
                UpdateCore.warn("Unable to create versioned identifier:" + id + ":" + ver);
            }
        }
        this.versionId = new VersionedIdentifier(this.getURL().toExternalForm(), null);
        return this.versionId;
    }

    public ISite getSite() {
        return this.site;
    }

    public URL getURL() {
        IFeatureContentProvider contentProvider = null;
        try {
            contentProvider = this.getFeatureContentProvider();
        }
        catch (CoreException e) {
            UpdateCore.warn("No content Provider", e);
        }
        return contentProvider != null ? contentProvider.getURL() : null;
    }

    public IURLEntry getUpdateSiteEntry() {
        return (IURLEntry)((Object)this.getUpdateSiteEntryModel());
    }

    public IURLEntry[] getDiscoverySiteEntries() {
        URLEntryModel[] result = this.getDiscoverySiteEntryModels();
        if (result.length == 0) {
            return new IURLEntry[0];
        }
        return (IURLEntry[])result;
    }

    public IInstallHandlerEntry getInstallHandlerEntry() {
        return (IInstallHandlerEntry)((Object)this.getInstallHandlerModel());
    }

    public IURLEntry getDescription() {
        return (IURLEntry)((Object)this.getDescriptionModel());
    }

    public IURLEntry getCopyright() {
        return (IURLEntry)((Object)this.getCopyrightModel());
    }

    public IURLEntry getLicense() {
        return (IURLEntry)((Object)this.getLicenseModel());
    }

    public URL getImage() {
        return this.getImageURL();
    }

    public IImport[] getRawImports() {
        ImportModel[] result = this.getImportModels();
        if (result.length == 0) {
            return new IImport[0];
        }
        return (IImport[])result;
    }

    public IFeatureReference install(IFeature targetFeature, IVerificationListener verificationListener, IProgressMonitor progress) throws InstallAbortedException, CoreException {
        return this.install(targetFeature, null, verificationListener, progress);
    }

    /*
     * Exception decompiling
     */
    public IFeatureReference install(IFeature targetFeature, IFeatureReference[] optionalfeatures, IVerificationListener verificationListener, IProgressMonitor progress) throws InstallAbortedException, CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Nonsensical loop would be emitted - failure
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopIdentifier.considerAsDoLoopStart(LoopIdentifier.java:438)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopIdentifier.identifyLoops1(LoopIdentifier.java:65)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:681)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public IPluginEntry[] getRawPluginEntries() {
        PluginEntryModel[] result = this.getPluginEntryModels();
        if (result.length == 0) {
            return new IPluginEntry[0];
        }
        return (IPluginEntry[])result;
    }

    private IPluginEntry[] filterPluginEntry(IPluginEntry[] all) {
        ArrayList<IPluginEntry> list = new ArrayList<IPluginEntry>();
        if (all != null) {
            int i = 0;
            while (i < all.length) {
                if (UpdateManagerUtils.isValidEnvironment(all[i])) {
                    list.add(all[i]);
                }
                ++i;
            }
        }
        IPluginEntry[] result = new IPluginEntry[list.size()];
        if (!list.isEmpty()) {
            list.toArray(result);
        }
        return result;
    }

    public int getPluginEntryCount() {
        return this.getPluginEntries().length;
    }

    public INonPluginEntry[] getRawNonPluginEntries() {
        NonPluginEntryModel[] result = this.getNonPluginEntryModels();
        if (result.length == 0) {
            return new INonPluginEntry[0];
        }
        return (INonPluginEntry[])result;
    }

    public int getNonPluginEntryCount() {
        return this.getNonPluginEntryModels().length;
    }

    public IIncludedFeatureReference[] getRawIncludedFeatureReferences() throws CoreException {
        if (this.includedFeatureReferences == null) {
            this.initializeIncludedReferences();
        }
        if (this.includedFeatureReferences.size() == 0) {
            return new IncludedFeatureReference[0];
        }
        return this.includedFeatureReferences.toArray(new IIncludedFeatureReference[this.includedFeatureReferences.size()]);
    }

    public long getDownloadSize() {
        try {
            HashSet<IPluginEntry> allPluginEntries = new HashSet<IPluginEntry>();
            HashSet<INonPluginEntry> allNonPluginEntries = new HashSet<INonPluginEntry>();
            IPluginEntry[] plugins = this.getPluginEntries();
            allPluginEntries.addAll(Arrays.asList(plugins));
            INonPluginEntry[] nonPlugins = this.getNonPluginEntries();
            allNonPluginEntries.addAll(Arrays.asList(nonPlugins));
            IIncludedFeatureReference[] children = this.getIncludedFeatureReferences();
            int i = 0;
            while (i < children.length) {
                plugins = children[i].getFeature(null).getPluginEntries();
                allPluginEntries.addAll(Arrays.asList(plugins));
                nonPlugins = children[i].getFeature(null).getNonPluginEntries();
                allNonPluginEntries.addAll(Arrays.asList(nonPlugins));
                ++i;
            }
            IPluginEntry[] totalPlugins = new IPluginEntry[allPluginEntries.size()];
            INonPluginEntry[] totalNonPlugins = new INonPluginEntry[allNonPluginEntries.size()];
            if (allPluginEntries.size() != 0) {
                allPluginEntries.toArray(totalPlugins);
            }
            if (allNonPluginEntries.size() != 0) {
                allNonPluginEntries.toArray(totalNonPlugins);
            }
            return this.getFeatureContentProvider().getDownloadSizeFor(totalPlugins, totalNonPlugins);
        }
        catch (CoreException e) {
            UpdateCore.warn(null, e);
            return -1L;
        }
    }

    public long getInstallSize() {
        try {
            HashSet<IPluginEntry> allPluginEntries = new HashSet<IPluginEntry>();
            HashSet<INonPluginEntry> allNonPluginEntries = new HashSet<INonPluginEntry>();
            IPluginEntry[] plugins = this.getPluginEntries();
            allPluginEntries.addAll(Arrays.asList(plugins));
            INonPluginEntry[] nonPlugins = this.getNonPluginEntries();
            allNonPluginEntries.addAll(Arrays.asList(nonPlugins));
            IIncludedFeatureReference[] children = this.getIncludedFeatureReferences();
            int i = 0;
            while (i < children.length) {
                plugins = children[i].getFeature(null).getPluginEntries();
                allPluginEntries.addAll(Arrays.asList(plugins));
                nonPlugins = children[i].getFeature(null).getNonPluginEntries();
                allNonPluginEntries.addAll(Arrays.asList(nonPlugins));
                ++i;
            }
            IPluginEntry[] totalPlugins = new IPluginEntry[allPluginEntries.size()];
            INonPluginEntry[] totalNonPlugins = new INonPluginEntry[allNonPluginEntries.size()];
            if (allPluginEntries.size() != 0) {
                allPluginEntries.toArray(totalPlugins);
            }
            if (allNonPluginEntries.size() != 0) {
                allNonPluginEntries.toArray(totalNonPlugins);
            }
            return this.getFeatureContentProvider().getInstallSizeFor(totalPlugins, totalNonPlugins);
        }
        catch (CoreException e) {
            UpdateCore.warn(null, e);
            return -1L;
        }
    }

    public IFeatureContentProvider getFeatureContentProvider() throws CoreException {
        if (this.featureContentProvider == null) {
            throw Utilities.newCoreException(NLS.bind(Messages.Feature_NoContentProvider, new String[]{this.getVersionedIdentifier().toString()}), null);
        }
        return this.featureContentProvider;
    }

    public IFeatureContentConsumer getFeatureContentConsumer() throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void setSite(ISite site) throws CoreException {
        if (this.site != null) {
            String featureURLString = this.getURL() != null ? this.getURL().toExternalForm() : "";
            throw Utilities.newCoreException(NLS.bind(Messages.Feature_SiteAlreadySet, new String[]{featureURLString}), null);
        }
        this.site = site;
    }

    public void setFeatureContentProvider(IFeatureContentProvider featureContentProvider) {
        this.featureContentProvider = featureContentProvider;
        featureContentProvider.setFeature(this);
    }

    public String toString() {
        String URLString = this.getURL() == null ? Messages.Feature_NoURL : this.getURL().toExternalForm();
        String verString = NLS.bind(Messages.Feature_FeatureVersionToString, new String[]{URLString, this.getVersionedIdentifier().toString()});
        String label = this.getLabel() == null ? "" : this.getLabel();
        return String.valueOf(verString) + " [" + label + "]";
    }

    private void abort() throws CoreException {
        String msg = Messages.Feature_InstallationCancelled;
        throw new InstallAbortedException(msg, null);
    }

    private void initializeIncludedReferences() throws CoreException {
        this.includedFeatureReferences = new ArrayList();
        IIncludedFeatureReference[] nestedFeatures = this.getFeatureIncluded();
        if (nestedFeatures.length == 0) {
            return;
        }
        ISite site = this.getSite();
        if (site == null) {
            return;
        }
        int i = 0;
        while (i < nestedFeatures.length) {
            IIncludedFeatureReference include = nestedFeatures[i];
            IIncludedFeatureReference newRef = this.getPerfectIncludeFeature(site, include);
            this.includedFeatureReferences.add(newRef);
            ++i;
        }
    }

    private IIncludedFeatureReference getPerfectIncludeFeature(ISite site, IIncludedFeatureReference include) throws CoreException {
        ISiteFeatureReference[] refs = site.getFeatureReferences();
        VersionedIdentifier identifier = include.getVersionedIdentifier();
        if ("file".equals(site.getURL().getProtocol()) && refs != null) {
            int ref = 0;
            while (ref < refs.length) {
                VersionedIdentifier id;
                if (refs[ref] != null && identifier.equals(id = refs[ref].getVersionedIdentifier())) {
                    IncludedFeatureReference newRef = new IncludedFeatureReference(refs[ref]);
                    newRef.isOptional(include.isOptional());
                    if (include instanceof FeatureReferenceModel) {
                        newRef.setLabel(((FeatureReferenceModel)((Object)include)).getLabel());
                    }
                    newRef.setSearchLocation(include.getSearchLocation());
                    return newRef;
                }
                ++ref;
            }
        }
        UpdateSiteIncludedFeatureReference newRef = new UpdateSiteIncludedFeatureReference(include);
        newRef.setSite(this.getSite());
        ISiteFeatureReference parentRef = this.getSite().getFeatureReference(this);
        if (parentRef instanceof FeatureReference) {
            newRef.setType(((FeatureReference)((Object)parentRef)).getType());
        }
        String featureID = "features/" + identifier.toString();
        featureID = this instanceof TargetFeature ? String.valueOf(featureID) + "/" : String.valueOf(featureID) + ".jar";
        URL featureURL = this.getSite().getSiteContentProvider().getArchiveReference(featureID);
        newRef.setURL(featureURL);
        newRef.setFeatureIdentifier(identifier.getIdentifier());
        newRef.setFeatureVersion(identifier.getVersion().toString());
        try {
            newRef.resolve(this.getSite().getURL(), null);
            return newRef;
        }
        catch (Exception e) {
            throw Utilities.newCoreException(NLS.bind(Messages.Feature_UnableToInitializeFeatureReference, new String[]{identifier.toString()}), e);
        }
    }

    private void debug(String trace) {
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_INSTALL) {
            UpdateCore.debug(trace);
        }
    }

    private void setMonitorTaskName(IProgressMonitor monitor, String taskName) {
        if (monitor != null) {
            monitor.setTaskName(taskName);
        }
    }

    private void monitorWork(IProgressMonitor monitor, int tick) throws CoreException {
        if (monitor != null) {
            monitor.worked(tick);
            if (monitor.isCanceled()) {
                this.abort();
            }
        }
    }

    private void verifyReferences(IVerifier verifier, ContentReference[] references, InstallMonitor monitor, IVerificationListener verificationListener, boolean isFeature) throws CoreException {
        IVerificationResult vr = null;
        if (verifier != null) {
            int j = 0;
            while (j < references.length) {
                vr = verifier.verify(this, references[j], isFeature, monitor);
                if (vr != null) {
                    if (verificationListener == null) {
                        return;
                    }
                    int result = verificationListener.prompt(vr);
                    if (result == 0) {
                        String msg = Messages.JarVerificationService_CancelInstall;
                        Exception e = vr.getVerificationException();
                        throw new InstallAbortedException(msg, e);
                    }
                    if (result == 1) {
                        throw Utilities.newCoreException(Messages.JarVerificationService_UnsucessfulVerification, vr.getVerificationException());
                    }
                }
                ++j;
            }
        }
    }

    private IFeatureReference featureAlreadyInstalled(ISite targetSite) {
        ISiteFeatureReference[] references = targetSite.getFeatureReferences();
        ISiteFeatureReference currentReference = null;
        int i = 0;
        while (i < references.length) {
            currentReference = references[i];
            try {
                if (this.equals(currentReference.getFeature(null))) {
                    return currentReference;
                }
            }
            catch (CoreException e) {
                UpdateCore.warn(null, e);
            }
            ++i;
        }
        UpdateCore.warn("ValidateAlreadyInstalled:Feature " + this + " not found on site:" + this.getURL());
        return null;
    }

    private void reinitializeFeature(IFeatureReference referenceToReinitialize) {
        if (referenceToReinitialize == null) {
            return;
        }
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_CONFIGURATION) {
            UpdateCore.debug("Re initialize feature reference:" + referenceToReinitialize);
        }
        IFeature feature = null;
        try {
            ISite site;
            feature = referenceToReinitialize.getFeature(null);
            if (feature != null && feature instanceof Feature) {
                ((Feature)feature).initializeIncludedReferences();
            }
            if ((site = referenceToReinitialize.getSite()) == null) {
                return;
            }
            URL url = site.getURL();
            if (url == null) {
                return;
            }
            if ("file".equals(url.getProtocol())) {
                IIncludedFeatureReference[] included = feature.getIncludedFeatureReferences();
                int i = 0;
                while (i < included.length) {
                    this.reinitializeFeature(included[i]);
                    ++i;
                }
            }
        }
        catch (CoreException e) {
            UpdateCore.warn("", e);
        }
    }

    public IIncludedFeatureReference[] getIncludedFeatureReferences() throws CoreException {
        return this.filterFeatures(this.getRawIncludedFeatureReferences());
    }

    private IIncludedFeatureReference[] filterFeatures(IIncludedFeatureReference[] allIncluded) {
        ArrayList<IIncludedFeatureReference> list = new ArrayList<IIncludedFeatureReference>();
        if (allIncluded != null) {
            int i = 0;
            while (i < allIncluded.length) {
                IIncludedFeatureReference included = allIncluded[i];
                if (UpdateManagerUtils.isValidEnvironment(included)) {
                    list.add(included);
                } else if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_WARNINGS) {
                    UpdateCore.warn("Filtered out feature reference:" + included);
                }
                ++i;
            }
        }
        IIncludedFeatureReference[] result = new IIncludedFeatureReference[list.size()];
        if (!list.isEmpty()) {
            list.toArray(result);
        }
        return result;
    }

    public INonPluginEntry[] getNonPluginEntries() {
        return this.filterNonPluginEntry(this.getRawNonPluginEntries());
    }

    private INonPluginEntry[] filterNonPluginEntry(INonPluginEntry[] all) {
        ArrayList<INonPluginEntry> list = new ArrayList<INonPluginEntry>();
        if (all != null) {
            int i = 0;
            while (i < all.length) {
                if (UpdateManagerUtils.isValidEnvironment(all[i])) {
                    list.add(all[i]);
                }
                ++i;
            }
        }
        INonPluginEntry[] result = new INonPluginEntry[list.size()];
        if (!list.isEmpty()) {
            list.toArray(result);
        }
        return result;
    }

    public IPluginEntry[] getPluginEntries() {
        return this.filterPluginEntry(this.getRawPluginEntries());
    }

    public IImport[] getImports() {
        return this.filterImports(this.getRawImports());
    }

    private IImport[] filterImports(IImport[] all) {
        ArrayList<IImport> list = new ArrayList<IImport>();
        if (all != null) {
            int i = 0;
            while (i < all.length) {
                if (UpdateManagerUtils.isValidEnvironment(all[i])) {
                    list.add(all[i]);
                }
                ++i;
            }
        }
        IImport[] result = new IImport[list.size()];
        if (!list.isEmpty()) {
            list.toArray(result);
        }
        return result;
    }
}

