/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.IContentConsumer;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.INonPluginEntry;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.SiteFeatureReference;
import org.eclipse.update.core.SiteFeatureReferenceModel;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.core.model.ArchiveReferenceModel;
import org.eclipse.update.core.model.PluginEntryModel;
import org.eclipse.update.internal.core.ContentConsumer;
import org.eclipse.update.internal.core.ErrorRecoveryLog;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.SiteContentConsumer;
import org.eclipse.update.internal.core.SiteFile;
import org.eclipse.update.internal.core.SiteFileFactory;
import org.eclipse.update.internal.core.SiteFileNonPluginContentConsumer;
import org.eclipse.update.internal.core.SiteFilePackedPluginContentConsumer;
import org.eclipse.update.internal.core.SiteFilePluginContentConsumer;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;

public class SiteFileContentConsumer
extends SiteContentConsumer {
    private IFeature feature;
    private boolean closed = false;
    private String oldPath;
    private String newPath;
    private List contentConsumers;
    private List installedFiles;
    private SiteFileFactory archiveFactory = new SiteFileFactory();

    public SiteFileContentConsumer(IFeature feature) {
        this.feature = feature;
        this.installedFiles = new ArrayList();
    }

    private String getFeaturePath() throws CoreException {
        String featurePath = null;
        try {
            VersionedIdentifier featureIdentifier = this.feature.getVersionedIdentifier();
            String path = "features/" + featureIdentifier.toString() + File.separator;
            URL newURL = new URL(this.getSite().getURL(), path);
            featurePath = newURL.getFile();
        }
        catch (MalformedURLException e) {
            throw Utilities.newCoreException(String.valueOf(Messages.SiteFileContentConsumer_UnableToCreateURL) + e.getMessage(), e);
        }
        return featurePath;
    }

    public IContentConsumer open(INonPluginEntry nonPluginEntry) throws CoreException {
        return new SiteFileNonPluginContentConsumer(this.getFeaturePath());
    }

    public IContentConsumer open(IPluginEntry pluginEntry) throws CoreException {
        ContentConsumer cons = pluginEntry instanceof PluginEntryModel && !((PluginEntryModel)((Object)pluginEntry)).isUnpack() ? new SiteFilePackedPluginContentConsumer(pluginEntry, this.getSite()) : new SiteFilePluginContentConsumer(pluginEntry, this.getSite());
        this.addContentConsumers(cons);
        return cons;
    }

    public void store(ContentReference contentReference, IProgressMonitor monitor) throws CoreException {
        if (this.closed) {
            UpdateCore.warn("Attempt to store in a closed SiteFileContentConsumer", new Exception());
            return;
        }
        InputStream inStream = null;
        String featurePath = this.getFeaturePath();
        String contentKey = contentReference.getIdentifier();
        if ((featurePath = String.valueOf(featurePath) + contentKey).endsWith("\\feature.xml") || featurePath.endsWith("/feature.xml")) {
            this.oldPath = featurePath.replace(File.separatorChar, '/');
            File localFile = new File(this.oldPath);
            if (localFile.exists()) {
                throw Utilities.newCoreException(NLS.bind(Messages.UpdateManagerUtils_FileAlreadyExists, new Object[]{localFile}), null);
            }
            this.newPath = featurePath = ErrorRecoveryLog.getLocalRandomIdentifier(featurePath);
            ErrorRecoveryLog.getLog().appendPath("FEATURE", featurePath);
        }
        try {
            try {
                inStream = contentReference.getInputStream();
                UpdateManagerUtils.copyToLocal(inStream, featurePath, null);
                UpdateManagerUtils.checkPermissions(contentReference, featurePath);
                this.installedFiles.add(featurePath);
            }
            catch (IOException e) {
                throw Utilities.newCoreException(NLS.bind(Messages.GlobalConsumer_ErrorCreatingFile, new String[]{featurePath}), e);
            }
        }
        catch (Throwable throwable) {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (inStream != null) {
            try {
                inStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public IFeatureReference close() throws CoreException {
        if (this.closed) {
            UpdateCore.warn("Attempt to close a closed SiteFileContentConsumer", new Exception());
        }
        SiteFeatureReference ref = new SiteFeatureReference();
        ref.setSite(this.getSite());
        File file = null;
        try {
            file = new File(this.getFeaturePath());
            ref.setURL(file.toURL());
        }
        catch (MalformedURLException e) {
            throw Utilities.newCoreException(NLS.bind(Messages.SiteFileContentConsumer_UnableToCreateURLForFile, new String[]{file.getAbsolutePath()}), e);
        }
        if (this.newPath != null) {
            ErrorRecoveryLog.getLog().appendPath("RENAME", this.newPath);
            boolean sucess = false;
            File fileToRename = new File(this.newPath);
            if (fileToRename.exists()) {
                File renamedFile = new File(this.oldPath);
                if (renamedFile.exists()) {
                    UpdateManagerUtils.removeFromFileSystem(renamedFile);
                    UpdateCore.warn("Removing already existing file:" + this.oldPath);
                }
                sucess = fileToRename.renameTo(renamedFile);
            }
            if (!sucess) {
                String msg = NLS.bind(Messages.ContentConsumer_UnableToRename, new String[]{this.newPath, this.oldPath});
                throw Utilities.newCoreException(msg, new Exception(msg));
            }
        }
        if (this.contentConsumers != null) {
            Iterator iter = this.contentConsumers.iterator();
            while (iter.hasNext()) {
                ContentConsumer element = (ContentConsumer)iter.next();
                element.close();
            }
        }
        this.contentConsumers = null;
        if (ref != null) {
            this.commitPlugins(ref);
            ref.markReadOnly();
        }
        this.closed = true;
        return ref;
    }

    public void abort() throws CoreException {
        if (this.closed) {
            UpdateCore.warn("Attempt to abort a closed SiteFileContentConsumer", new Exception());
            return;
        }
        if (this.contentConsumers != null) {
            Iterator iter = this.contentConsumers.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                if (element instanceof SiteFilePluginContentConsumer) {
                    ((SiteFilePluginContentConsumer)element).abort();
                    continue;
                }
                if (!(element instanceof SiteFilePackedPluginContentConsumer)) continue;
                ((SiteFilePackedPluginContentConsumer)element).abort();
            }
        }
        this.contentConsumers = null;
        boolean sucess = true;
        if (this.oldPath != null) {
            ErrorRecoveryLog.getLog().appendPath("DELETE", this.oldPath);
            File fileToDelete = new File(this.oldPath);
            if (fileToDelete.exists()) {
                sucess = fileToDelete.delete();
            }
        }
        if (!sucess) {
            String msg = NLS.bind(Messages.SiteFileContentConsumer_unableToDelete, new String[]{this.oldPath});
            UpdateCore.log(msg, null);
        } else {
            Iterator iter = this.installedFiles.iterator();
            File featureFile = null;
            while (iter.hasNext()) {
                String path = (String)iter.next();
                featureFile = new File(path);
                UpdateManagerUtils.removeFromFileSystem(featureFile);
            }
            String featurePath = this.getFeaturePath();
            UpdateManagerUtils.removeEmptyDirectoriesFromFileSystem(new File(featurePath));
        }
        this.closed = true;
    }

    private void commitPlugins(IFeatureReference localFeatureReference) throws CoreException {
        ((SiteFile)this.getSite()).addFeatureReferenceModel((SiteFeatureReferenceModel)localFeatureReference);
        IFeature localFeature = null;
        try {
            localFeature = localFeatureReference.getFeature(null);
        }
        catch (CoreException e) {
            UpdateCore.warn(null, e);
            return;
        }
        if (localFeature == null) {
            return;
        }
        ArchiveReferenceModel archive = null;
        IPluginEntry[] pluginEntries = localFeature.getPluginEntries();
        int i = 0;
        while (i < pluginEntries.length) {
            String versionId = pluginEntries[i].getVersionedIdentifier().toString();
            String pluginID = "plugins/" + versionId + ".jar";
            archive = this.archiveFactory.createArchiveReferenceModel();
            archive.setPath(pluginID);
            try {
                URL url = null;
                url = pluginEntries[i] instanceof PluginEntryModel && !((PluginEntryModel)((Object)pluginEntries[i])).isUnpack() ? new URL(this.getSite().getURL(), "plugins/" + versionId + ".jar") : new URL(this.getSite().getURL(), "plugins/" + versionId + File.separator);
                archive.setURLString(url.toExternalForm());
                archive.resolve(url, null);
                ((SiteFile)this.getSite()).addArchiveReferenceModel(archive);
            }
            catch (MalformedURLException e) {
                String urlString = this.getSite().getURL() != null ? this.getSite().getURL().toExternalForm() : "";
                urlString = String.valueOf(urlString) + "plugins/" + pluginEntries[i].toString();
                throw Utilities.newCoreException(NLS.bind(Messages.SiteFile_UnableToCreateURL, new String[]{urlString}), e);
            }
            ++i;
        }
    }

    private void addContentConsumers(ContentConsumer cons) {
        if (this.contentConsumers == null) {
            this.contentConsumers = new ArrayList();
        }
        this.contentConsumers.add(cons);
    }
}

