/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.model.InstallAbortedException;
import org.eclipse.update.internal.core.FeatureDownloadException;
import org.eclipse.update.internal.core.LiteFeature;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.operations.DuplicateConflictsValidator;
import org.eclipse.update.internal.operations.InstallOperation;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.UpdateUIImages;
import org.eclipse.update.internal.ui.UpdateUIMessages;
import org.eclipse.update.internal.ui.security.JarVerificationService;
import org.eclipse.update.internal.ui.wizards.DuplicateConflictsDialog;
import org.eclipse.update.internal.ui.wizards.ISearchProvider;
import org.eclipse.update.internal.ui.wizards.LicensePage;
import org.eclipse.update.internal.ui.wizards.OptionalFeaturesPage;
import org.eclipse.update.internal.ui.wizards.ReviewPage;
import org.eclipse.update.internal.ui.wizards.TargetPage;
import org.eclipse.update.operations.IBatchOperation;
import org.eclipse.update.operations.IFeatureOperation;
import org.eclipse.update.operations.IInstallFeatureOperation;
import org.eclipse.update.operations.IOperation;
import org.eclipse.update.operations.IOperationListener;
import org.eclipse.update.operations.OperationsManager;
import org.eclipse.update.search.UpdateSearchRequest;

public class InstallWizard2
extends Wizard
implements IOperationListener,
ISearchProvider {
    private ReviewPage reviewPage;
    private LicensePage licensePage;
    private OptionalFeaturesPage optionalFeaturesPage;
    private TargetPage targetPage;
    private IInstallConfiguration config;
    private int installCount = 0;
    private UpdateSearchRequest searchRequest;
    private ArrayList jobs;
    private boolean needsRestart;
    private static boolean isRunning;
    private IBatchOperation installOperation;
    private Job job;
    public static final Object jobFamily;
    private IJobChangeListener jobListener;
    private boolean isUpdate;

    static {
        jobFamily = new Object();
    }

    public InstallWizard2(UpdateSearchRequest searchRequest, IInstallFeatureOperation[] jobs, boolean isUpdate) {
        this(searchRequest, new ArrayList<IInstallFeatureOperation>(Arrays.asList(jobs)), isUpdate);
    }

    public InstallWizard2(UpdateSearchRequest searchRequest, ArrayList jobs, boolean isUpdate) {
        this.isUpdate = isUpdate;
        this.searchRequest = searchRequest;
        this.jobs = jobs;
        isRunning = true;
        this.setDialogSettings(UpdateUI.getDefault().getDialogSettings());
        this.setDefaultPageImageDescriptor(UpdateUIImages.DESC_UPDATE_WIZ);
        this.setForcePreviousAndNextButtons(true);
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(UpdateUIMessages.InstallWizard_wtitle);
    }

    public int getInstallCount() {
        return this.installCount;
    }

    public boolean isRestartNeeded() {
        return this.installCount > 0 && this.needsRestart;
    }

    public boolean performCancel() {
        isRunning = false;
        if (this.targetPage != null) {
            this.targetPage.removeAddedSites();
        }
        return super.performCancel();
    }

    public boolean performFinish() {
        boolean proceed;
        DuplicateConflictsDialog dialog;
        IInstallFeatureOperation[] selectedJobs = this.reviewPage.getSelectedJobs();
        ArrayList conflicts = DuplicateConflictsValidator.computeDuplicateConflicts(selectedJobs, this.config);
        if (conflicts != null && (dialog = new DuplicateConflictsDialog(this.getShell(), conflicts)).open() != 0) {
            return false;
        }
        if (Job.getJobManager().find(jobFamily).length > 0 && !(proceed = MessageDialog.openQuestion(UpdateUI.getActiveWorkbenchShell(), UpdateUIMessages.InstallWizard_anotherJobTitle, UpdateUIMessages.InstallWizard_anotherJob))) {
            return false;
        }
        this.installOperation = this.getBatchInstallOperation(selectedJobs);
        if (this.installOperation != null) {
            this.launchInBackground();
        }
        return true;
    }

    public void addPages() {
        this.reviewPage = new ReviewPage(this.isUpdate, this.searchRequest, this.jobs);
        this.addPage(this.reviewPage);
        try {
            this.config = SiteManager.getLocalSite().getCurrentConfiguration();
        }
        catch (CoreException e) {
            UpdateUI.logException(e);
        }
        this.licensePage = new LicensePage(true);
        this.addPage(this.licensePage);
        this.optionalFeaturesPage = new OptionalFeaturesPage(this.config);
        this.addPage(this.optionalFeaturesPage);
        this.targetPage = new TargetPage(this.config, this.isUpdate);
        this.addPage(this.targetPage);
    }

    private boolean isPageRequired(IWizardPage page) {
        if (page == null) {
            return false;
        }
        if (page.equals(this.licensePage)) {
            return OperationsManager.hasSelectedJobsWithLicenses(this.reviewPage.getSelectedJobs());
        }
        if (page.equals(this.optionalFeaturesPage)) {
            return OperationsManager.hasSelectedJobsWithOptionalFeatures(this.reviewPage.getSelectedJobs());
        }
        if (page.equals(this.targetPage)) {
            return this.reviewPage.getSelectedJobs().length > 0;
        }
        return true;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage[] pages = this.getPages();
        boolean start = false;
        IWizardPage nextPage = null;
        if (page.equals(this.reviewPage)) {
            this.updateDynamicPages();
        }
        int i = 0;
        while (i < pages.length) {
            if (pages[i].equals(page)) {
                start = true;
            } else if (start && this.isPageRequired(pages[i])) {
                nextPage = pages[i];
                break;
            }
            ++i;
        }
        return nextPage;
    }

    private void updateDynamicPages() {
        if (this.licensePage != null) {
            IInstallFeatureOperation[] licenseJobs = OperationsManager.getSelectedJobsWithLicenses(this.reviewPage.getSelectedJobs());
            this.licensePage.setJobs(licenseJobs);
        }
        if (this.optionalFeaturesPage != null) {
            IInstallFeatureOperation[] optionalJobs = OperationsManager.getSelectedJobsWithOptionalFeatures(this.reviewPage.getSelectedJobs());
            this.optionalFeaturesPage.setJobs(optionalJobs);
        }
        if (this.targetPage != null) {
            IInstallFeatureOperation[] installJobs = this.reviewPage.getSelectedJobs();
            this.targetPage.setJobs(installJobs);
        }
    }

    public boolean canFinish() {
        IWizardPage page = this.getContainer().getCurrentPage();
        return page.equals(this.targetPage) && page.isPageComplete();
    }

    private void preserveOriginatingURLs(IFeature feature, IFeatureReference[] optionalFeatures) {
        URL url = feature.getSite().getURL();
        try {
            IIncludedFeatureReference[] irefs = feature.getIncludedFeatureReferences();
            int i = 0;
            while (i < irefs.length) {
                IIncludedFeatureReference iref = irefs[i];
                boolean preserve = false;
                if (iref.isOptional()) {
                    boolean onTheList = false;
                    int j = 0;
                    while (j < optionalFeatures.length) {
                        if (optionalFeatures[j].equals(iref)) {
                            onTheList = true;
                            break;
                        }
                        ++j;
                    }
                    if (!onTheList) {
                        preserve = true;
                    }
                }
                if (preserve) {
                    try {
                        String id = iref.getVersionedIdentifier().getIdentifier();
                        UpdateUI.setOriginatingURL(id, url);
                    }
                    catch (CoreException coreException) {}
                } else {
                    try {
                        IFeature ifeature = iref.getFeature(null);
                        this.preserveOriginatingURLs(ifeature, optionalFeatures);
                    }
                    catch (CoreException coreException) {}
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
    }

    public boolean afterExecute(IOperation operation, Object data) {
        if (!(operation instanceof IInstallFeatureOperation)) {
            return true;
        }
        IInstallFeatureOperation job = (IInstallFeatureOperation)operation;
        IFeature oldFeature = job.getOldFeature();
        if (oldFeature == null && job.getOptionalFeatures() != null) {
            this.preserveOriginatingURLs(job.getFeature(), job.getOptionalFeatures());
        }
        ++this.installCount;
        return true;
    }

    public boolean beforeExecute(IOperation operation, Object data) {
        return true;
    }

    public UpdateSearchRequest getSearchRequest() {
        return this.searchRequest;
    }

    public static synchronized boolean isRunning() {
        return isRunning || Job.getJobManager().find(jobFamily).length > 0;
    }

    private IBatchOperation getBatchInstallOperation(IInstallFeatureOperation[] selectedJobs) {
        JarVerificationService verificationListener = new JarVerificationService(UpdateUI.getActiveWorkbenchShell());
        IInstallFeatureOperation[] operations = new IInstallFeatureOperation[selectedJobs.length];
        int i = 0;
        while (i < selectedJobs.length) {
            IInstallFeatureOperation op;
            IInstallFeatureOperation job = selectedJobs[i];
            IFeature[] unconfiguredOptionalFeatures = null;
            IFeatureReference[] optionalFeatures = null;
            if (UpdateUtils.hasOptionalFeatures(job.getFeature())) {
                optionalFeatures = this.optionalFeaturesPage.getCheckedOptionalFeatures(job);
                unconfiguredOptionalFeatures = this.optionalFeaturesPage.getUnconfiguredOptionalFeatures(job, job.getTargetSite());
            }
            operations[i] = op = OperationsManager.getOperationFactory().createInstallOperation(job.getTargetSite(), job.getFeature(), optionalFeatures, unconfiguredOptionalFeatures, verificationListener);
            ++i;
        }
        return OperationsManager.getOperationFactory().createBatchInstallOperation(operations);
    }

    private void launchInBackground() {
        if (this.jobListener != null) {
            Job.getJobManager().removeJobChangeListener(this.jobListener);
        }
        if (this.job != null) {
            Job.getJobManager().cancel(this.job);
        }
        this.jobListener = new UpdateJobChangeListener();
        Job.getJobManager().addJobChangeListener(this.jobListener);
        this.job = new Job(UpdateUIMessages.InstallWizard_jobName){

            public IStatus run(IProgressMonitor monitor) {
                if (InstallWizard2.this.download(monitor)) {
                    return Status.OK_STATUS;
                }
                isRunning = false;
                return Status.CANCEL_STATUS;
            }

            public boolean belongsTo(Object family) {
                return jobFamily == family;
            }
        };
        this.job.setUser(true);
        this.job.setPriority(10);
        this.job.schedule();
    }

    /*
     * Unable to fully structure code
     */
    private boolean install(IProgressMonitor monitor) {
        try {
            try {
                this.needsRestart = this.installOperation.execute(monitor, this);
                UpdateUI.getStandardDisplay().asyncExec(new Runnable(){

                    public void run() {
                        UpdateUI.requestRestart(InstallWizard2.this.isRestartNeeded());
                    }
                });
            }
            catch (InvocationTargetException e) {
                targetException = e.getTargetException();
                if (!(targetException instanceof InstallAbortedException)) {
                    UpdateUI.getStandardDisplay().syncExec(new Runnable(){

                        public void run() {
                            UpdateUI.logException(targetException);
                        }
                    });
                }
lbl10:
                // 4 sources

                while (true) {
                    InstallWizard2.isRunning = false;
                    return false;
                }
            }
            catch (CoreException v0) {
                ** continue;
            }
        }
        finally {
            InstallWizard2.isRunning = false;
        }
        return true;
    }

    private boolean download(IProgressMonitor monitor) {
        try {
            IFeatureOperation[] ops = this.installOperation.getOperations();
            monitor.beginTask(UpdateUIMessages.InstallWizard_download, 5 * ops.length);
            int i = 0;
            while (i < ops.length) {
                IInstallFeatureOperation op = (IInstallFeatureOperation)ops[i];
                try {
                    String featureName = op.getFeature().getLabel();
                    if (featureName == null || featureName.trim() == "") {
                        featureName = op.getFeature().getVersionedIdentifier().getIdentifier();
                    }
                    SubProgressMonitor featureDownloadMonitor = new SubProgressMonitor(monitor, 2);
                    featureDownloadMonitor.beginTask(featureName, 2);
                    featureDownloadMonitor.subTask(NLS.bind(UpdateUIMessages.InstallWizard_downloadingFeatureJar, featureName));
                    if (op.getFeature() instanceof LiteFeature) {
                        ISiteFeatureReference featureReference = this.getFeatureReference(op.getFeature());
                        IFeature feature = featureReference.getFeature(featureDownloadMonitor);
                        if (op instanceof InstallOperation) {
                            ((InstallOperation)op).setFeature(feature);
                        }
                    }
                    SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 3);
                    UpdateUtils.downloadFeatureContent(op.getTargetSite(), op.getFeature(), op.getOptionalFeatures(), subMonitor);
                }
                catch (CoreException e) {
                    if (e instanceof FeatureDownloadException) {
                        boolean retry = this.retryDownload((FeatureDownloadException)e);
                        if (retry) {
                            --i;
                        }
                    } else {
                        UpdateCore.log(e);
                        if (!monitor.isCanceled()) {
                            Display.getDefault().syncExec(new Runnable(){

                                public void run() {
                                    Status status = new Status(4, UpdateUI.getPluginId(), 0, UpdateUIMessages.InstallWizard2_updateOperationHasFailed, e);
                                    ErrorDialog.openError(null, null, null, status);
                                }
                            });
                        }
                    }
                    monitor.done();
                    return false;
                }
                ++i;
            }
            return true;
        }
        finally {
            monitor.done();
        }
    }

    private boolean retryDownload(final FeatureDownloadException e) {
        final boolean[] retry = new boolean[1];
        UpdateUI.getStandardDisplay().syncExec(new Runnable(){

            public void run() {
                retry[0] = MessageDialog.openQuestion(UpdateUI.getActiveWorkbenchShell(), UpdateUIMessages.InstallWizard_retryTitle, String.valueOf(e.getMessage()) + "\n" + UpdateUIMessages.InstallWizard_retry);
            }
        });
        return retry[0];
    }

    public ISiteFeatureReference getFeatureReference(IFeature feature) {
        ISite site = feature.getSite();
        ISiteFeatureReference[] references = site.getFeatureReferences();
        ISiteFeatureReference currentReference = null;
        int i = 0;
        while (i < references.length) {
            currentReference = references[i];
            try {
                if (feature.getVersionedIdentifier().equals(currentReference.getVersionedIdentifier())) {
                    return currentReference;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++i;
        }
        UpdateCore.warn("Feature " + feature + " not found on site" + site.getURL());
        return null;
    }

    static /* synthetic */ boolean access$1(InstallWizard2 installWizard2, IProgressMonitor iProgressMonitor) {
        return installWizard2.install(iProgressMonitor);
    }

    private class UpdateJobChangeListener
    extends JobChangeAdapter {
        private UpdateJobChangeListener() {
        }

        public void done(IJobChangeEvent event) {
            if (event.getJob() == InstallWizard2.this.job && event.getResult() == Status.OK_STATUS) {
                Job.getJobManager().removeJobChangeListener(this);
                Job.getJobManager().cancel(InstallWizard2.this.job);
                Job installJob = new Job(this, UpdateUIMessages.InstallWizard_jobName){
                    final /* synthetic */ UpdateJobChangeListener this$1;
                    {
                        this.this$1 = updateJobChangeListener;
                    }

                    public IStatus run(IProgressMonitor monitor) {
                        if (InstallWizard2.access$1(UpdateJobChangeListener.access$1(this.this$1), monitor)) {
                            return Status.OK_STATUS;
                        }
                        InstallWizard2.access$2(false);
                        return Status.CANCEL_STATUS;
                    }

                    public boolean belongsTo(Object family) {
                        return jobFamily == family;
                    }
                };
                installJob.setUser(true);
                installJob.setPriority(10);
                installJob.schedule();
            } else if (event.getJob() == InstallWizard2.this.job && event.getResult() != Status.OK_STATUS) {
                isRunning = false;
                Job.getJobManager().removeJobChangeListener(this);
                Job.getJobManager().cancel(InstallWizard2.this.job);
                UpdateUI.getStandardDisplay().syncExec(new Runnable(this, event){
                    final /* synthetic */ UpdateJobChangeListener this$1;
                    private final /* synthetic */ IJobChangeEvent val$event;
                    {
                        this.this$1 = updateJobChangeListener;
                        this.val$event = iJobChangeEvent;
                    }

                    public void run() {
                        UpdateUI.log(this.val$event.getResult(), true);
                    }
                });
            }
        }

        static /* synthetic */ InstallWizard2 access$1(UpdateJobChangeListener updateJobChangeListener) {
            return updateJobChangeListener.InstallWizard2.this;
        }
    }
}

