/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.common.logging;

import com.savvytest.eclipse.common.Savvytest;
import com.savvytest.eclipse.common.logging.AbstractSavvytestLogging;
import com.savvytest.eclipse.common.logging.LogLevel;
import java.text.DateFormat;
import java.util.Calendar;

public class ConsoleLogging
extends AbstractSavvytestLogging {
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.common.logging.ConsoleLogging.";
    private DateFormat format = DateFormat.getDateTimeInstance();

    private static final String getClassString(String key) {
        return Savvytest.getString(TRANSLATION_PREFIX + key, new Object[0]);
    }

    public static String getDisplayName() {
        return ConsoleLogging.getClassString("displayName");
    }

    @Override
    protected void logDebug(String log, Object caller) {
        this.doLog(log, LogLevel.DEBUG, caller);
    }

    @Override
    protected void logInfo(String log, Object caller) {
        this.doLog(log, LogLevel.INFO, caller);
    }

    @Override
    protected void logWarning(String log, Object caller) {
        this.doLog(log, LogLevel.WARNING, caller);
    }

    @Override
    protected void logError(String log, Object caller) {
        this.doLog(log, LogLevel.ERROR, caller);
    }

    @Override
    protected void logFatal(String log, Object caller) {
        this.doLog(log, LogLevel.FATAL, caller);
    }

    @Override
    protected void logException(Exception e, Object caller) {
        this.doLog(String.valueOf(e.getClass().getSimpleName()) + ": " + e.getMessage(), LogLevel.ERROR, caller);
        e.printStackTrace();
    }

    protected void doLog(String log, LogLevel level, Object caller) {
        System.out.println(this.createLog(log, level, caller));
    }

    protected String createLog(String log, LogLevel level, Object caller) {
        String classStr = "";
        if (caller != null) {
            Class<?> clazz = caller instanceof Class ? (Class<?>)caller : caller.getClass();
            while (clazz.isAnonymousClass()) {
                clazz = clazz.getEnclosingClass();
            }
            classStr = clazz.getSimpleName();
        }
        StringBuilder builder = new StringBuilder(200);
        builder.append(this.getTimeStamp());
        builder.append(' ');
        builder.append(this.getLevel(level));
        builder.append(" : ");
        builder.append(log);
        if (caller != null) {
            builder.append(" (");
            builder.append(classStr);
            builder.append(')');
        }
        return builder.toString();
    }

    private String getTimeStamp() {
        return this.format.format(Calendar.getInstance().getTime());
    }

    private String getLevel(LogLevel level) {
        String lvl = "UNKNOWN";
        if (level != null) {
            switch (level) {
                case DEBUG: {
                    lvl = "DEBUG";
                    break;
                }
                case ERROR: {
                    lvl = "ERROR";
                    break;
                }
                case FATAL: {
                    lvl = "FATAL";
                    break;
                }
                case INFO: {
                    lvl = "INFO ";
                    break;
                }
                case WARNING: {
                    lvl = "WARN ";
                }
            }
        }
        return lvl;
    }
}

