/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding;

import java.util.Collections;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.UpdateListStrategy;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.internal.databinding.BindingStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

public class ListBinding
extends Binding {
    private UpdateListStrategy targetToModel;
    private UpdateListStrategy modelToTarget;
    private IObservableValue validationStatusObservable;
    private boolean updatingTarget;
    private boolean updatingModel;
    private IListChangeListener targetChangeListener = new IListChangeListener(){

        public void handleListChange(ListChangeEvent event) {
            if (!ListBinding.this.updatingTarget) {
                ListBinding.this.doUpdate((IObservableList)ListBinding.this.getTarget(), (IObservableList)ListBinding.this.getModel(), event.diff, ListBinding.this.targetToModel, false, false);
            }
        }
    };
    private IListChangeListener modelChangeListener = new IListChangeListener(){

        public void handleListChange(ListChangeEvent event) {
            if (!ListBinding.this.updatingModel) {
                ListBinding.this.doUpdate((IObservableList)ListBinding.this.getModel(), (IObservableList)ListBinding.this.getTarget(), event.diff, ListBinding.this.modelToTarget, false, false);
            }
        }
    };
    static /* synthetic */ Class class$0;

    public ListBinding(IObservableList target, IObservableList model, UpdateListStrategy targetToModelStrategy, UpdateListStrategy modelToTargetStrategy) {
        super(target, model);
        this.targetToModel = targetToModelStrategy;
        this.modelToTarget = modelToTargetStrategy;
        if ((this.targetToModel.getUpdatePolicy() & UpdateValueStrategy.POLICY_UPDATE) != 0) {
            target.addListChangeListener(this.targetChangeListener);
        } else {
            this.targetChangeListener = null;
        }
        if ((this.modelToTarget.getUpdatePolicy() & UpdateValueStrategy.POLICY_UPDATE) != 0) {
            model.addListChangeListener(this.modelChangeListener);
        } else {
            this.modelChangeListener = null;
        }
    }

    public IObservableValue getValidationStatus() {
        return this.validationStatusObservable;
    }

    protected void preInit() {
        Realm realm = this.context.getValidationRealm();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.runtime.IStatus");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.validationStatusObservable = new WritableValue(realm, Status.OK_STATUS, clazz);
    }

    protected void postInit() {
        if (this.modelToTarget.getUpdatePolicy() == UpdateListStrategy.POLICY_UPDATE) {
            this.updateModelToTarget();
        }
        if (this.targetToModel.getUpdatePolicy() != UpdateListStrategy.POLICY_NEVER) {
            this.validateTargetToModel();
        }
    }

    public void updateModelToTarget() {
        final IObservableList modelList = (IObservableList)this.getModel();
        modelList.getRealm().exec(new Runnable(){

            public void run() {
                ListDiff diff = Diffs.computeListDiff(Collections.EMPTY_LIST, modelList);
                ListBinding.this.doUpdate(modelList, (IObservableList)ListBinding.this.getTarget(), diff, ListBinding.this.modelToTarget, true, true);
            }
        });
    }

    public void updateTargetToModel() {
        final IObservableList targetList = (IObservableList)this.getTarget();
        targetList.getRealm().exec(new Runnable(){

            public void run() {
                ListDiff diff = Diffs.computeListDiff(Collections.EMPTY_LIST, targetList);
                ListBinding.this.doUpdate(targetList, (IObservableList)ListBinding.this.getModel(), diff, ListBinding.this.targetToModel, true, true);
            }
        });
    }

    public void validateModelToTarget() {
    }

    public void validateTargetToModel() {
    }

    private void doUpdate(IObservableList source, final IObservableList destination, final ListDiff diff, final UpdateListStrategy updateListStrategy, boolean explicit, final boolean clearDestination) {
        int policy = updateListStrategy.getUpdatePolicy();
        if (policy != UpdateListStrategy.POLICY_NEVER && (policy != UpdateListStrategy.POLICY_ON_REQUEST || explicit)) {
            destination.getRealm().exec(new Runnable(){

                public void run() {
                    if (destination == ListBinding.this.getTarget()) {
                        ListBinding.this.updatingTarget = true;
                    } else {
                        ListBinding.this.updatingModel = true;
                    }
                    BindingStatus multiStatus = BindingStatus.ok();
                    try {
                        if (clearDestination) {
                            destination.clear();
                        }
                        ListDiffEntry[] diffEntries = diff.getDifferences();
                        int i = 0;
                        while (i < diffEntries.length) {
                            IStatus setterStatus;
                            ListDiffEntry listDiffEntry = diffEntries[i];
                            if (listDiffEntry.isAddition()) {
                                setterStatus = updateListStrategy.doAdd(destination, updateListStrategy.convert(listDiffEntry.getElement()), listDiffEntry.getPosition());
                                ListBinding.this.mergeStatus(multiStatus, setterStatus);
                            } else {
                                setterStatus = updateListStrategy.doRemove(destination, listDiffEntry.getPosition());
                                ListBinding.this.mergeStatus(multiStatus, setterStatus);
                            }
                            ++i;
                        }
                    }
                    finally {
                        ListBinding.this.validationStatusObservable.setValue(multiStatus);
                        if (destination == ListBinding.this.getTarget()) {
                            ListBinding.this.updatingTarget = false;
                        } else {
                            ListBinding.this.updatingModel = false;
                        }
                    }
                }
            });
        }
    }

    void mergeStatus(MultiStatus multiStatus, IStatus newStatus) {
        if (!newStatus.isOK()) {
            multiStatus.add(newStatus);
        }
    }

    public void dispose() {
        if (this.targetChangeListener != null) {
            ((IObservableList)this.getTarget()).removeListChangeListener(this.targetChangeListener);
            this.targetChangeListener = null;
        }
        if (this.modelChangeListener != null) {
            ((IObservableList)this.getModel()).removeListChangeListener(this.modelChangeListener);
            this.modelChangeListener = null;
        }
        super.dispose();
    }
}

