/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.internal.swt;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.jface.internal.databinding.provisional.swt.AbstractSWTObservableValue;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public abstract class SingleSelectionObservableValue
extends AbstractSWTObservableValue {
    private boolean updating = false;
    private int currentSelection = this.doGetSelectionIndex();

    public SingleSelectionObservableValue(Control control) {
        super((Widget)control);
        this.doAddSelectionListener(new Runnable(){

            public void run() {
                if (!SingleSelectionObservableValue.this.updating) {
                    int newSelection = SingleSelectionObservableValue.this.doGetSelectionIndex();
                    SingleSelectionObservableValue.this.fireValueChange(Diffs.createValueDiff(new Integer(SingleSelectionObservableValue.this.currentSelection), new Integer(newSelection)));
                    SingleSelectionObservableValue.this.currentSelection = newSelection;
                }
            }
        });
    }

    protected abstract void doAddSelectionListener(Runnable var1);

    public void doSetValue(Object value) {
        try {
            this.updating = true;
            int intValue = (Integer)value;
            this.doSetSelectionIndex(intValue);
            this.currentSelection = intValue;
        }
        finally {
            this.updating = false;
        }
    }

    protected abstract void doSetSelectionIndex(int var1);

    public Object doGetValue() {
        return new Integer(this.doGetSelectionIndex());
    }

    protected abstract int doGetSelectionIndex();

    public Object getValueType() {
        return Integer.TYPE;
    }
}

