/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.serviceregistry;

import org.eclipse.osgi.internal.framework.BundleContextImpl;
import org.eclipse.osgi.internal.messages.Msg;
import org.eclipse.osgi.internal.serviceregistry.ServiceConsumer;
import org.eclipse.osgi.internal.serviceregistry.ServiceRegistrationImpl;
import org.osgi.framework.ServiceObjects;
import org.osgi.framework.ServiceReference;

public class ServiceObjectsImpl<S>
implements ServiceObjects<S> {
    private final ServiceRegistrationImpl<S> registration;
    private final ServiceReference<S> reference;
    private final BundleContextImpl user;

    ServiceObjectsImpl(BundleContextImpl user, ServiceRegistrationImpl<S> registration) {
        this.registration = registration;
        this.reference = registration.getReference();
        this.user = user;
    }

    @Override
    public S getService() {
        this.user.checkValid();
        return (S)this.registration.getService(this.user, ServiceConsumer.prototypeConsumer);
    }

    @Override
    public void ungetService(S service) {
        this.user.checkValid();
        boolean removed = this.registration.ungetService(this.user, ServiceConsumer.prototypeConsumer, service);
        if (!removed) {
            if (this.registration.isUnregistered()) {
                return;
            }
            throw new IllegalArgumentException(Msg.SERVICE_OBJECTS_UNGET_ARGUMENT_EXCEPTION);
        }
    }

    @Override
    public ServiceReference<S> getServiceReference() {
        return this.reference;
    }
}

