/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.ide.undo.CreateMarkersOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.views.bookmarkexplorer.BookmarkMessages;
import org.eclipse.ui.views.bookmarkexplorer.BookmarkPropertiesDialog;

public class AddBookmarkAction
extends SelectionListenerAction {
    public static final String ID = "org.eclipse.ui.AddBookmarkAction";
    private Shell shell;
    private boolean promptForName = true;
    static /* synthetic */ Class class$0;

    public AddBookmarkAction(Shell shell) {
        this(shell, true);
    }

    public AddBookmarkAction(Shell shell, boolean promptForName) {
        super(IDEWorkbenchMessages.AddBookmarkLabel);
        this.setId(ID);
        if (shell == null) {
            throw new IllegalArgumentException();
        }
        this.shell = shell;
        this.promptForName = promptForName;
        this.setToolTipText(IDEWorkbenchMessages.AddBookmarkToolTip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this, "org.eclipse.ui.ide.add_bookmark_action_context");
    }

    public void run() {
        IStructuredSelection selection = this.getStructuredSelection();
        Iterator i = selection.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            IFile file = null;
            if (o instanceof IFile) {
                file = (IFile)o;
            } else if (o instanceof IAdaptable) {
                Object resource;
                IAdaptable iAdaptable = (IAdaptable)o;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((resource = iAdaptable.getAdapter(clazz)) instanceof IFile) {
                    file = (IFile)resource;
                }
            }
            if (file == null) continue;
            if (this.promptForName) {
                BookmarkPropertiesDialog dialog = new BookmarkPropertiesDialog(this.shell);
                dialog.setResource(file);
                dialog.open();
                continue;
            }
            HashMap<String, String> attrs = new HashMap<String, String>();
            attrs.put("message", file.getName());
            CreateMarkersOperation op = new CreateMarkersOperation("org.eclipse.core.resources.bookmark", attrs, file, BookmarkMessages.CreateBookmark_undoText);
            try {
                PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute(op, null, WorkspaceUndoUtil.getUIInfoAdapter(this.shell));
            }
            catch (ExecutionException e) {
                IDEWorkbenchPlugin.log(null, e);
            }
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        return super.updateSelection(selection) && !selection.isEmpty() && this.selectionIsOfType(1);
    }
}

