/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.internal.ide.DialogUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.part.FileEditorInput;

public class OpenSystemEditorAction
extends SelectionListenerAction {
    public static final String ID = "org.eclipse.ui.OpenSystemEditorAction";
    private IWorkbenchPage workbenchPage;

    public OpenSystemEditorAction(IWorkbenchPage page) {
        super(IDEWorkbenchMessages.OpenSystemEditorAction_text);
        this.setToolTipText(IDEWorkbenchMessages.OpenSystemEditorAction_toolTip);
        this.setId(ID);
        page.getWorkbenchWindow().getWorkbench().getHelpSystem().setHelp(this, "org.eclipse.ui.ide.open_system_editor_action_context");
        if (page == null) {
            throw new IllegalArgumentException();
        }
        this.workbenchPage = page;
    }

    final IWorkbenchPage getWorkbenchPage() {
        return this.workbenchPage;
    }

    void openFile(IFile file) {
        try {
            this.getWorkbenchPage().openEditor(new FileEditorInput(file), "org.eclipse.ui.systemExternalEditor");
        }
        catch (PartInitException e) {
            DialogUtil.openError(this.getWorkbenchPage().getWorkbenchWindow().getShell(), IDEWorkbenchMessages.OpenSystemEditorAction_dialogTitle, e.getMessage(), e);
        }
    }

    public void run() {
        Iterator itr = this.getSelectedResources().iterator();
        while (itr.hasNext()) {
            IResource resource = (IResource)itr.next();
            if (!(resource instanceof IFile)) continue;
            this.openFile((IFile)resource);
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        return super.updateSelection(selection) && this.selectionIsOfType(1);
    }
}

