/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.menus.MenuLocationURI;
import org.eclipse.ui.internal.provisional.presentations.IActionBarPresentationFactory;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.menus.AbstractContributionFactory;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.IContributionRoot;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.menus.WorkbenchWindowControlContribution;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.services.IServiceLocator;

public class MenuAdditionCacheEntry
extends AbstractContributionFactory {
    private IConfigurationElement additionElement;
    Map iciToConfigElementMap = new HashMap();
    Set failedLoads = new HashSet();
    private HashMap visWhenMap = new HashMap();
    private IMenuService menuService;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public MenuAdditionCacheEntry(IMenuService menuService, IConfigurationElement element, String location, String namespace) {
        super(location, namespace);
        this.menuService = menuService;
        this.additionElement = element;
        this.generateSubCaches();
    }

    private void generateSubCaches() {
        IConfigurationElement[] items = this.additionElement.getChildren();
        int i = 0;
        while (i < items.length) {
            String itemType = items[i].getName();
            if ("menu".equals(itemType) || "toolbar".equals(itemType)) {
                String location = String.valueOf(new MenuLocationURI(this.getLocation()).getScheme()) + ":" + MenuAdditionCacheEntry.getId(items[i]);
                MenuAdditionCacheEntry subMenuEntry = new MenuAdditionCacheEntry(this.menuService, items[i], location, this.getNamespace());
                this.menuService.addContributionFactory(subMenuEntry);
            }
            ++i;
        }
    }

    private Expression getVisibleWhenForItem(IContributionItem item) {
        IConfigurationElement configElement = (IConfigurationElement)this.iciToConfigElementMap.get(item);
        if (configElement == null) {
            return null;
        }
        if (!this.visWhenMap.containsKey(configElement)) {
            try {
                IConfigurationElement[] visibleChild;
                IConfigurationElement[] visibleConfig = configElement.getChildren("visibleWhen");
                if (visibleConfig.length > 0 && visibleConfig.length < 2 && (visibleChild = visibleConfig[0].getChildren()).length > 0) {
                    Expression visWhen = ExpressionConverter.getDefault().perform(visibleChild[0]);
                    this.visWhenMap.put(configElement, visWhen);
                }
            }
            catch (InvalidRegistryObjectException e) {
                this.visWhenMap.put(configElement, null);
                e.printStackTrace();
            }
            catch (CoreException e) {
                this.visWhenMap.put(configElement, null);
                e.printStackTrace();
            }
        }
        return (Expression)this.visWhenMap.get(configElement);
    }

    public void createContributionItems(IServiceLocator serviceLocator, IContributionRoot additions) {
        WorkbenchWindow window;
        IActionBarPresentationFactory actionBarPresentationFactory = null;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.IWorkbenchWindow");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((window = (WorkbenchWindow)serviceLocator.getService(clazz)) != null) {
            actionBarPresentationFactory = window.getActionBarPresentationFactory();
        }
        IConfigurationElement[] items = this.additionElement.getChildren();
        int i = 0;
        while (i < items.length) {
            String itemType = items[i].getName();
            IContributionItem newItem = null;
            if ("command".equals(itemType)) {
                newItem = this.createCommandAdditionContribution(serviceLocator, items[i]);
            } else if ("dynamic".equals(itemType)) {
                newItem = this.createDynamicAdditionContribution(items[i]);
            } else if ("control".equals(itemType)) {
                newItem = this.createControlAdditionContribution(items[i]);
            } else if ("separator".equals(itemType)) {
                newItem = this.createSeparatorAdditionContribution(items[i]);
            } else if ("menu".equals(itemType)) {
                newItem = this.createMenuAdditionContribution(items[i]);
            } else if ("toolbar".equals(itemType)) {
                newItem = this.createToolBarAdditionContribution(actionBarPresentationFactory, items[i]);
            }
            if (newItem != null) {
                this.iciToConfigElementMap.put(newItem, items[i]);
                additions.addContributionItem(newItem, this.getVisibleWhenForItem(newItem));
            }
            ++i;
        }
    }

    private IContributionItem createToolBarAdditionContribution(IActionBarPresentationFactory actionBarPresentationFactory, IConfigurationElement configurationElement) {
        if (!this.getLocation().startsWith("toolbar")) {
            return null;
        }
        if (actionBarPresentationFactory != null) {
            return actionBarPresentationFactory.createToolBarContributionItem(actionBarPresentationFactory.createToolBarManager(), MenuAdditionCacheEntry.getId(configurationElement));
        }
        return new ToolBarContributionItem(new ToolBarManager(), MenuAdditionCacheEntry.getId(configurationElement));
    }

    private IContributionItem createMenuAdditionContribution(IConfigurationElement menuAddition) {
        int idx;
        if (this.getLocation().startsWith("toolbar")) {
            return null;
        }
        String text = MenuAdditionCacheEntry.getLabel(menuAddition);
        String mnemonic = MenuAdditionCacheEntry.getMnemonic(menuAddition);
        if (text != null && mnemonic != null && (idx = text.indexOf(mnemonic)) != -1) {
            text = String.valueOf(text.substring(0, idx)) + '&' + text.substring(idx);
        }
        return new MenuManager(text, MenuAdditionCacheEntry.getId(menuAddition));
    }

    private IContributionItem createSeparatorAdditionContribution(IConfigurationElement sepAddition) {
        if (MenuAdditionCacheEntry.isSeparatorVisible(sepAddition)) {
            return new Separator(MenuAdditionCacheEntry.getName(sepAddition));
        }
        return new GroupMarker(MenuAdditionCacheEntry.getName(sepAddition));
    }

    private IContributionItem createDynamicAdditionContribution(IConfigurationElement dynamicAddition) {
        CompoundContributionItem loadedDynamicContribution;
        if (this.failedLoads.contains(dynamicAddition)) {
            return null;
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.actions.CompoundContributionItem");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((loadedDynamicContribution = (CompoundContributionItem)Util.safeLoadExecutableExtension(dynamicAddition, "class", clazz)) == null) {
            this.failedLoads.add(loadedDynamicContribution);
            return null;
        }
        return loadedDynamicContribution;
    }

    private IContributionItem createControlAdditionContribution(IConfigurationElement widgetAddition) {
        WorkbenchWindowControlContribution loadedWidget;
        if (!this.getLocation().startsWith("toolbar")) {
            return null;
        }
        if (this.failedLoads.contains(widgetAddition)) {
            return null;
        }
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.ui.menus.WorkbenchWindowControlContribution");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((loadedWidget = (WorkbenchWindowControlContribution)Util.safeLoadExecutableExtension(widgetAddition, "class", clazz)) == null) {
            this.failedLoads.add(widgetAddition);
            return null;
        }
        loadedWidget.setId(MenuAdditionCacheEntry.getId(widgetAddition));
        return loadedWidget;
    }

    private IContributionItem createCommandAdditionContribution(IServiceLocator locator, IConfigurationElement commandAddition) {
        return new CommandContributionItem(locator, MenuAdditionCacheEntry.getId(commandAddition), MenuAdditionCacheEntry.getCommandId(commandAddition), MenuAdditionCacheEntry.getParameters(commandAddition), MenuAdditionCacheEntry.getIconDescriptor(commandAddition), MenuAdditionCacheEntry.getDisabledIconDescriptor(commandAddition), MenuAdditionCacheEntry.getHoverIconDescriptor(commandAddition), MenuAdditionCacheEntry.getLabel(commandAddition), MenuAdditionCacheEntry.getMnemonic(commandAddition), MenuAdditionCacheEntry.getTooltip(commandAddition), this.getStyle(commandAddition));
    }

    public static String getId(IConfigurationElement element) {
        String id = element.getAttribute("id");
        if (id == null || id.length() == 0) {
            id = element.toString();
        }
        return id;
    }

    static String getName(IConfigurationElement element) {
        return element.getAttribute("name");
    }

    static String getLabel(IConfigurationElement element) {
        return element.getAttribute("label");
    }

    static String getMnemonic(IConfigurationElement element) {
        return element.getAttribute("mnemonic");
    }

    static String getTooltip(IConfigurationElement element) {
        return element.getAttribute("tooltip");
    }

    static String getIconPath(IConfigurationElement element) {
        return element.getAttribute("icon");
    }

    static String getDisabledIconPath(IConfigurationElement element) {
        return element.getAttribute("disabledIcon");
    }

    static String getHoverIconPath(IConfigurationElement element) {
        return element.getAttribute("hoverIcon");
    }

    static ImageDescriptor getIconDescriptor(IConfigurationElement element) {
        String extendingPluginId = element.getDeclaringExtension().getContributor().getName();
        String iconPath = MenuAdditionCacheEntry.getIconPath(element);
        if (iconPath != null) {
            return AbstractUIPlugin.imageDescriptorFromPlugin(extendingPluginId, iconPath);
        }
        return null;
    }

    static ImageDescriptor getDisabledIconDescriptor(IConfigurationElement element) {
        String extendingPluginId = element.getDeclaringExtension().getContributor().getName();
        String iconPath = MenuAdditionCacheEntry.getDisabledIconPath(element);
        if (iconPath != null) {
            return AbstractUIPlugin.imageDescriptorFromPlugin(extendingPluginId, iconPath);
        }
        return null;
    }

    static ImageDescriptor getHoverIconDescriptor(IConfigurationElement element) {
        String extendingPluginId = element.getDeclaringExtension().getContributor().getName();
        String iconPath = MenuAdditionCacheEntry.getHoverIconPath(element);
        if (iconPath != null) {
            return AbstractUIPlugin.imageDescriptorFromPlugin(extendingPluginId, iconPath);
        }
        return null;
    }

    public static boolean isSeparatorVisible(IConfigurationElement element) {
        String val = element.getAttribute("visible");
        return Boolean.valueOf(val);
    }

    public static String getClassSpec(IConfigurationElement element) {
        return element.getAttribute("class");
    }

    public static String getCommandId(IConfigurationElement element) {
        return element.getAttribute("commandId");
    }

    private int getStyle(IConfigurationElement element) {
        String style = element.getAttribute("style");
        if (style == null || style.length() == 0) {
            return 8;
        }
        if ("toggle".equals(style)) {
            return 32;
        }
        if ("radio".equals(style)) {
            return 16;
        }
        if ("pulldown".equals(style)) {
            return 4;
        }
        return 8;
    }

    public static Map getParameters(IConfigurationElement element) {
        HashMap<String, String> map = new HashMap<String, String>();
        IConfigurationElement[] parameters = element.getChildren("parameter");
        int i = 0;
        while (i < parameters.length) {
            String name = parameters[i].getAttribute("name");
            String value = parameters[i].getAttribute("value");
            if (name != null && value != null) {
                map.put(name, value);
            }
            ++i;
        }
        return map;
    }
}

