/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.framelist;

import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.views.framelist.FrameListMessages;
import org.eclipse.ui.views.framelist.Frame;
import org.eclipse.ui.views.framelist.FrameAction;
import org.eclipse.ui.views.framelist.FrameList;

public class UpAction
extends FrameAction {
    public UpAction(FrameList frameList) {
        super(frameList);
        this.setText(FrameListMessages.Up_text);
        ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_UP"));
        this.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_UP_DISABLED"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this, "org.eclipse.ui.up_action_context");
        this.update();
    }

    Frame getParentFrame(int flags) {
        return this.getFrameList().getSource().getFrame(3, flags);
    }

    String getToolTipText(Frame parentFrame) {
        String text;
        if (parentFrame != null && (text = parentFrame.getToolTipText()) != null && text.length() > 0) {
            return NLS.bind(FrameListMessages.Up_toolTipOneArg, text);
        }
        return FrameListMessages.Up_toolTip;
    }

    public void run() {
        Frame parentFrame = this.getParentFrame(1);
        if (parentFrame != null) {
            this.getFrameList().gotoFrame(parentFrame);
        }
    }

    public void update() {
        super.update();
        Frame parentFrame = this.getParentFrame(0);
        this.setEnabled(parentFrame != null);
        this.setToolTipText(this.getToolTipText(parentFrame));
    }
}

