/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.tasklist;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.ide.DialogUtil;
import org.eclipse.ui.internal.views.tasklist.TaskListMessages;
import org.eclipse.ui.views.tasklist.TaskAction;
import org.eclipse.ui.views.tasklist.TaskList;

class GotoTaskAction
extends TaskAction {
    public GotoTaskAction(TaskList tasklist, String id) {
        super(tasklist, id);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this, "org.eclipse.ui.goto_task_action_context");
    }

    public void run() {
        IStructuredSelection selection = (IStructuredSelection)this.getTaskList().getSelection();
        Object o = selection.getFirstElement();
        if (!(o instanceof IMarker)) {
            return;
        }
        IMarker marker = (IMarker)o;
        IResource resource = marker.getResource();
        if (marker.exists() && resource instanceof IFile) {
            IWorkbenchPage page = this.getTaskList().getSite().getPage();
            try {
                IDE.openEditor(page, marker, OpenStrategy.activateOnOpen());
            }
            catch (PartInitException e) {
                DialogUtil.openError(page.getWorkbenchWindow().getShell(), TaskListMessages.GotoTask_errorMessage, e.getMessage(), e);
            }
        }
    }
}

