/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.IOException;
import java.util.jar.JarEntry;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.core.BaseInstallHandler;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.IContentConsumer;
import org.eclipse.update.core.IFeatureContentConsumer;
import org.eclipse.update.core.IFeatureContentProvider;
import org.eclipse.update.core.INonPluginEntry;
import org.eclipse.update.core.IVerificationListener;
import org.eclipse.update.core.IVerificationResult;
import org.eclipse.update.core.IVerifier;
import org.eclipse.update.core.JarContentReference;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.model.InstallAbortedException;
import org.eclipse.update.internal.core.Messages;

public class DefaultInstallHandler
extends BaseInstallHandler {
    public void nonPluginDataDownloaded(INonPluginEntry[] nonPluginData, IVerificationListener listener) throws CoreException {
        if (nonPluginData == null || nonPluginData.length == 0) {
            return;
        }
        this.nonPluginEntries = nonPluginData;
        IFeatureContentProvider provider = this.feature.getFeatureContentProvider();
        IVerifier verifier = provider.getVerifier();
        if (verifier == null) {
            return;
        }
        int i = 0;
        while (i < this.nonPluginEntries.length) {
            ContentReference[] archives = provider.getNonPluginEntryArchiveReferences(this.nonPluginEntries[i], this.monitor);
            int j = 0;
            while (j < archives.length) {
                IVerificationResult result;
                ContentReference archive = archives[j];
                if (!(archives[j] instanceof JarContentReference) && archives[j].getIdentifier().endsWith(".jar")) {
                    try {
                        archive = new JarContentReference(archives[j].getIdentifier(), archives[j].asFile());
                    }
                    catch (IOException iOException) {}
                }
                if ((result = verifier.verify(this.feature, archive, false, this.monitor)) != null) {
                    this.promptForVerification(result, listener);
                }
                ++j;
            }
            ++i;
        }
    }

    public void completeInstall(IFeatureContentConsumer consumer) throws CoreException {
        if (this.nonPluginEntries == null || this.nonPluginEntries.length == 0) {
            return;
        }
        IFeatureContentProvider provider = this.feature.getFeatureContentProvider();
        int i = 0;
        while (i < this.nonPluginEntries.length) {
            ContentReference[] archive = provider.getNonPluginEntryArchiveReferences(this.nonPluginEntries[i], this.monitor);
            IContentConsumer nonPluginConsumer = consumer.open(this.nonPluginEntries[i]);
            int j = 0;
            while (j < archive.length) {
                String id = archive[j].getIdentifier();
                if (id.endsWith(".jar")) {
                    try {
                        final String prefix = String.valueOf(id.substring(0, id.length() - 4)) + "/";
                        JarContentReference jarRef = new JarContentReference("", archive[j].asFile());
                        JarContentReference.ContentSelector selector = new JarContentReference.ContentSelector(){

                            public String defineIdentifier(JarEntry entry) {
                                if (entry == null) {
                                    return null;
                                }
                                return String.valueOf(prefix) + entry.getName();
                            }
                        };
                        ContentReference[] entries = jarRef.peek(selector, this.monitor);
                        int k = 0;
                        while (k < entries.length) {
                            nonPluginConsumer.store(entries[k], this.monitor);
                            ++k;
                        }
                    }
                    catch (IOException e) {
                        throw Utilities.newCoreException(NLS.bind(Messages.JarVerificationService_CancelInstall, new String[]{id}), e);
                    }
                } else {
                    nonPluginConsumer.store(archive[j], this.monitor);
                }
                ++j;
            }
            nonPluginConsumer.close();
            ++i;
        }
    }

    private void promptForVerification(IVerificationResult verificationResult, IVerificationListener listener) throws CoreException {
        if (listener == null) {
            return;
        }
        int result = listener.prompt(verificationResult);
        if (result == 0) {
            Exception e = verificationResult.getVerificationException();
            throw new InstallAbortedException(Messages.JarVerificationService_CancelInstall, e);
        }
        if (result == 1) {
            throw Utilities.newCoreException(Messages.JarVerificationService_UnsucessfulVerification, verificationResult.getVerificationException());
        }
    }
}

