/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.views;

import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.internal.search.OptionalFeatureSearchCategory;
import org.eclipse.update.internal.ui.UpdateUIMessages;
import org.eclipse.update.internal.ui.model.MissingFeature;
import org.eclipse.update.internal.ui.wizards.InstallWizard;
import org.eclipse.update.internal.ui.wizards.ResizableInstallWizardDialog;
import org.eclipse.update.operations.OperationsManager;
import org.eclipse.update.search.UpdateSearchRequest;
import org.eclipse.update.search.UpdateSearchScope;

public class InstallOptionalFeatureAction
extends Action {
    private MissingFeature missingFeature;
    private Shell shell;

    public InstallOptionalFeatureAction(Shell shell, String text) {
        super(text);
        this.shell = shell;
    }

    public void setFeature(MissingFeature feature) {
        this.missingFeature = feature;
    }

    public void run() {
        if (this.missingFeature == null) {
            return;
        }
        IStatus status = OperationsManager.getValidator().validatePlatformConfigValid();
        if (status != null) {
            ErrorDialog.openError(this.shell, null, null, status);
            return;
        }
        if (OperationsManager.getValidator().validateCurrentState() != null && !this.confirm(UpdateUIMessages.Actions_brokenConfigQuestion)) {
            return;
        }
        VersionedIdentifier vid = this.missingFeature.getVersionedIdentifier();
        URL originatingURL = this.missingFeature.getOriginatingSiteURL();
        UpdateSearchScope scope = new UpdateSearchScope();
        scope.addSearchSite(originatingURL.toString(), originatingURL, null);
        OptionalFeatureSearchCategory category = new OptionalFeatureSearchCategory();
        category.addVersionedIdentifier(vid);
        final UpdateSearchRequest searchRequest = new UpdateSearchRequest(category, scope);
        BusyIndicator.showWhile((Display)this.shell.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                InstallOptionalFeatureAction.this.openWizard(searchRequest);
            }
        });
    }

    private void openWizard(UpdateSearchRequest searchRequest) {
        if (InstallWizard.isRunning()) {
            MessageDialog.openInformation(this.shell, UpdateUIMessages.InstallWizard_isRunningTitle, UpdateUIMessages.InstallWizard_isRunningInfo);
            return;
        }
        InstallWizard wizard = new InstallWizard(searchRequest);
        ResizableInstallWizardDialog dialog = new ResizableInstallWizardDialog(this.shell, wizard, UpdateUIMessages.FeaturePage_optionalInstall_title);
        ((Dialog)dialog).create();
        ((Window)dialog).open();
    }

    private boolean confirm(String message) {
        return MessageDialog.openConfirm(this.shell, UpdateUIMessages.FeatureStateAction_dialogTitle, message);
    }
}

