/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.common.savvytestnature;

import com.savvytest.eclipse.common.savvytestnature.SavvytestTypeEnum;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.PlatformObject;

public class SavvytestProjectNature
extends PlatformObject
implements IProjectNature {
    private IProject project;

    public static boolean hasNature(IProject project, String natureId) {
        if (project != null) {
            try {
                return project.isNatureEnabled(natureId);
            }
            catch (CoreException coreException) {}
        }
        return false;
    }

    public static void addNatureToProject(IProject proj, String natureId, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = proj.getDescription();
        String[] prevNatures = description.getNatureIds();
        String[] newNatures = new String[prevNatures.length + 1];
        System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
        newNatures[prevNatures.length] = natureId;
        description.setNatureIds(newNatures);
        proj.setDescription(description, monitor);
    }

    public static void removeNatureFromProject(IProject proj, String natureId, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = proj.getDescription();
        String[] prevNatures = description.getNatureIds();
        String[] newNatures = new String[prevNatures.length - 1];
        int index = 0;
        int i = 0;
        while (i < prevNatures.length) {
            if (!natureId.equals(prevNatures[i])) {
                newNatures[index++] = prevNatures[i];
            }
            ++i;
        }
        description.setNatureIds(newNatures);
        proj.setDescription(description, monitor);
    }

    public static void createFolder(IFolder folder) throws CoreException {
        if (!folder.exists()) {
            IContainer parent = folder.getParent();
            if (parent instanceof IFolder) {
                SavvytestProjectNature.createFolder((IFolder)parent);
            }
            folder.create(true, true, null);
        }
    }

    @Override
    public void configure() throws CoreException {
        SavvytestTypeEnum[] savvytestTypeEnumArray = SavvytestTypeEnum.values();
        int n = savvytestTypeEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            SavvytestTypeEnum type = savvytestTypeEnumArray[n2];
            if (type.foldername != null) {
                IFolder folder = this.project.getFolder(type.foldername);
                SavvytestProjectNature.createFolder(folder);
            }
            ++n2;
        }
    }

    @Override
    public void deconfigure() throws CoreException {
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public void setProject(IProject project) {
        this.project = project;
    }
}

