/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.common.util;

import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.resources.IFile;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class SimpleXPathEvaluator {
    public static final XPathExpression XPATH_NAME;
    public static final XPathExpression XPATH_ALIAS;
    public static final XPathExpression XPATH_DESCRIPTION;
    private static final XPathFactory FACTORY_XPATH;
    private static final DocumentBuilderFactory FACTORY_DOM;
    private Document doc = null;
    private XPathExpression exp = null;

    static {
        FACTORY_DOM = DocumentBuilderFactory.newInstance();
        FACTORY_DOM.setNamespaceAware(false);
        FACTORY_XPATH = XPathFactory.newInstance();
        XPATH_NAME = SimpleXPathEvaluator.compileExpr("/*/@name");
        XPATH_ALIAS = SimpleXPathEvaluator.compileExpr("/*/@alias");
        XPATH_DESCRIPTION = SimpleXPathEvaluator.compileExpr("/*/description/text()");
    }

    private static final XPathExpression compileExpr(String xPath) {
        try {
            return FACTORY_XPATH.newXPath().compile(xPath);
        }
        catch (XPathExpressionException e) {
            SavvytestSettings.INSTANCE.getLogger().log(e, SimpleXPathEvaluator.class);
            return null;
        }
    }

    public String evaluateXPathForString() throws XPathExpressionException {
        return this.exp.evaluate(this.doc);
    }

    public String evaluateXPathForStringSecure() {
        if (this.doc == null || this.exp == null) {
            return null;
        }
        try {
            return this.evaluateXPathForString();
        }
        catch (XPathExpressionException e) {
            SavvytestSettings.INSTANCE.getLogger().log(e, (Object)this);
            return null;
        }
    }

    public void setDocument(Document doc) {
        this.doc = doc;
    }

    public void setDocument(String uri) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder builderDoc = FACTORY_DOM.newDocumentBuilder();
        this.doc = builderDoc.parse(uri);
    }

    public void setDocumentSecure(String uri) {
        try {
            this.setDocument(uri);
        }
        catch (ParserConfigurationException e) {
            this.doc = null;
            SavvytestSettings.INSTANCE.getLogger().log(e, (Object)this);
        }
        catch (SAXException e) {
            this.doc = null;
            SavvytestSettings.INSTANCE.getLogger().log(e, (Object)this);
        }
        catch (IOException e) {
            this.doc = null;
            SavvytestSettings.INSTANCE.getLogger().log(e, (Object)this);
        }
    }

    public void setDocument(IFile file) throws ParserConfigurationException, SAXException, IOException {
        this.setDocument(file.getRawLocationURI().toString());
    }

    public void setDocumentSecure(IFile file) {
        this.setDocumentSecure(file.getRawLocationURI().toString());
    }

    public void setXPath(XPathExpression xPath) {
        this.exp = xPath;
    }

    public void setXPath(String xPath) throws XPathExpressionException {
        XPath xpath = FACTORY_XPATH.newXPath();
        this.exp = xpath.compile(xPath);
    }

    public void setXPathSecure(String xPath) {
        try {
            this.setXPath(xPath);
        }
        catch (XPathExpressionException e) {
            this.exp = null;
            SavvytestSettings.INSTANCE.getLogger().log(e, (Object)this);
        }
    }
}

