/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.templates.result;

import com.savvytest.eclipse.core.model.xml.result.CheckconditionResult;
import com.savvytest.eclipse.core.model.xml.result.TestcaseResult;
import com.savvytest.eclipse.core.model.xml.result.TestscenarioResult;
import com.savvytest.eclipse.core.model.xml.result.TestsuiteResult;
import java.util.HashMap;
import java.util.Map;

public class JunitResultsXmlTemplate {
    protected static String nl;
    public final String NL = nl == null ? System.getProperties().getProperty("line.separator") : nl;
    protected final String TEXT_1 = "<testsuites disabled=\"\" errors=\"";
    protected final String TEXT_2 = "\" failures=\"";
    protected final String TEXT_3 = "\" name=\"";
    protected final String TEXT_4 = "\" tests=\"";
    protected final String TEXT_5 = "\" time=\"\">";
    protected final String TEXT_6 = String.valueOf(this.NL) + "    <testsuite disabled=\"\" errors=\"";
    protected final String TEXT_7 = "\" hostname=\"";
    protected final String TEXT_8 = "\" id=\"";
    protected final String TEXT_9 = "\"" + this.NL + "               name=\"";
    protected final String TEXT_10 = "\" package=\"\" skipped=\"\" tests=\"";
    protected final String TEXT_11 = "\" time=\"\" timestamp=\"\">" + this.NL + "        <properties>" + this.NL + "            <property name=\"\" value=\"\"/>" + this.NL + "        </properties>";
    protected final String TEXT_12 = String.valueOf(this.NL) + "        <testcase assertions=\"\" classname=\"";
    protected final String TEXT_13 = "\" status=\"\" time=\"\">";
    protected final String TEXT_14 = "\t\t " + this.NL + "            <failure message=\"";
    protected final String TEXT_15 = "\" type=\"\"/>";
    protected final String TEXT_16 = "         " + this.NL + "            <error message=\"";
    protected final String TEXT_17 = String.valueOf(this.NL) + "   \t\t</testcase>";
    protected final String TEXT_18 = "   " + this.NL + "        <system-out/>" + this.NL + "        <system-err/>";
    protected final String TEXT_19 = "        " + this.NL + "    </testsuite>" + this.NL + "</testsuites> ";

    public static synchronized JunitResultsXmlTemplate create(String lineSeparator) {
        nl = lineSeparator;
        JunitResultsXmlTemplate result = new JunitResultsXmlTemplate();
        nl = null;
        return result;
    }

    public String generate(Object argument) {
        StringBuffer stringBuffer = new StringBuffer();
        Map args = (Map)argument;
        TestsuiteResult testsuiteResult = (TestsuiteResult)args.get("TestsuiteResult");
        HashMap archiveProperties = (HashMap)args.get("ArchiveProperties");
        stringBuffer.append("<testsuites disabled=\"\" errors=\"");
        stringBuffer.append(testsuiteResult.getErrorCount());
        stringBuffer.append("\" failures=\"");
        stringBuffer.append(testsuiteResult.getFailureCount());
        stringBuffer.append("\" name=\"");
        stringBuffer.append(testsuiteResult.getTestsuite().getName());
        stringBuffer.append("\" tests=\"");
        stringBuffer.append(testsuiteResult.getTestCount());
        stringBuffer.append("\" time=\"\">");
        int numId = 0;
        for (TestscenarioResult testscenario : testsuiteResult.getTestscenarioResults()) {
            stringBuffer.append(this.TEXT_6);
            stringBuffer.append(testscenario.getErrorCount());
            stringBuffer.append("\" failures=\"");
            stringBuffer.append(testscenario.getFailureCount());
            stringBuffer.append("\" hostname=\"");
            stringBuffer.append((String)archiveProperties.get("SYSNAME"));
            stringBuffer.append("\" id=\"");
            stringBuffer.append(numId++);
            stringBuffer.append(this.TEXT_9);
            stringBuffer.append(testscenario.getTestscenario().getName());
            stringBuffer.append("\" package=\"\" skipped=\"\" tests=\"");
            stringBuffer.append(testscenario.getTestCount());
            stringBuffer.append(this.TEXT_11);
            for (TestcaseResult testcase : testscenario.getTestcaseResults()) {
                stringBuffer.append(this.TEXT_12);
                stringBuffer.append(testcase.getTestcase().getId());
                stringBuffer.append("\" name=\"");
                stringBuffer.append(testcase.getTestcase().getName());
                stringBuffer.append("\" status=\"\" time=\"\">");
                for (CheckconditionResult result : testcase.getResults()) {
                    switch (result.getResult()) {
                        case FAILURE: {
                            stringBuffer.append(this.TEXT_14);
                            stringBuffer.append(result.getMessage());
                            stringBuffer.append("\" type=\"\"/>");
                            break;
                        }
                        case ERROR: {
                            stringBuffer.append(this.TEXT_16);
                            stringBuffer.append(result.getMessage());
                            stringBuffer.append("\" type=\"\"/>");
                            break;
                        }
                    }
                }
                stringBuffer.append(this.TEXT_17);
            }
            stringBuffer.append(this.TEXT_18);
        }
        stringBuffer.append(this.TEXT_19);
        return stringBuffer.toString();
    }
}

